<?php
/**
* H&L Partners functions and definitions
*
* @package WordPress
* @subpackage H&L Partners
* @since Version 1.0
*/

date_default_timezone_set('America/Los_Angeles');
session_name("handlpartners");
session_set_cookie_params(0, '/', '.handlpartners.com');
session_start();

//============================================================
// Global Theme Settings
//============================================================

remove_action('wp_head','feed_links_extra',3);
remove_action('wp_head','feed_links',2);
remove_action('wp_head','rsd_link');
remove_action('wp_head','wlwmanifest_link');
remove_action('wp_head','index_rel_link');
remove_action('wp_head','parent_post_rel_link',10,0);
remove_action('wp_head','start_post_rel_link',10,0);
remove_action('wp_head','adjacent_posts_rel_link',10,0);
remove_action('wp_head','wp_generator');
remove_action('wp_head','print_emoji_detection_script',7);
remove_action('wp_print_styles','print_emoji_styles');
remove_filter('the_content','wpautop');
remove_filter('the_excerpt','wpautop');

function hlp_buttons($buttons) {
	$buttons[] = 'superscript';
	$buttons[] = 'subscript';
	$buttons[] = 'fontsizeselect';
	$buttons[] = 'cleanup';
	$buttons[] = 'styleselect';
	return $buttons;
}
add_filter('mce_buttons_2','hlp_buttons');

function hlp_mce_text_sizes($initArray){
	$initArray['fontsize_formats'] = "6px 8px 9px 10px 12px 14px 16px 18px 20px 22px 24px 28px 32px 36px";
	return $initArray;
}
add_filter('tiny_mce_before_init','hlp_mce_text_sizes');
add_filter('show_admin_bar','__return_false');
add_filter('types_information_table','__return_false');
add_filter('wpseo_primary_term_taxonomies','__return_false');

function hlp_user_can_richedit($editor){
	global $post_type;
    if($post_type === "page") return false;
    return $editor;
}
add_filter('user_can_richedit','hlp_user_can_richedit');

 //============================================================
// Theme Setup
//============================================================

function hlp_setup(){
    // This theme uses wp_nav_menu() in two locations.
	register_nav_menus(array(
		'Desktop' => __('Desktop Menu','hlp-desktop'),
		'Mobile' => __('Mobile Menu','hlp-mobile')
	));

	// Switch default core markup to HTML5.
	add_theme_support('html5',array('search-form','comment-form','comment-list','gallery','caption'));
}
add_action('after_setup_theme','hlp_setup');

function hlp_title($title){
	if(is_feed()) return $title;
	if(is_home() || is_front_page()) $title = "Home";
	else return $title . " | " . get_bloginfo('name');
}
add_filter('wp_title','hlp_title');

function hlp_excerpt_length($length) {
	return 26;
}
add_filter('excerpt_length','hlp_excerpt_length');

function hlp_scripts(){
	//$version = time();
	$version = '1.0.0';
    if(!is_admin()) wp_deregister_script('jquery');

    wp_register_style('fontawesome','//maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css', array(),'4.5.0');
    wp_register_style('webtype','//cloud.webtype.com/css/ddbf3967-15f7-4e0a-9332-38c3e89000ee.css', array(),'1.0');
    wp_register_style('foundation','/wp-content/themes/handlpartners/assets/vendor/foundation-sites/dist/foundation.css', array(),'6.0');
	wp_register_style('motion-ui','/wp-content/themes/handlpartners/assets/vendor/motion-ui/dist/motion-ui.min.css', array('foundation'),'6.0');
	wp_register_style('slick','/wp-content/themes/handlpartners/assets/vendor/slick/slick.css', array('foundation'),'1.5.9');
	wp_register_style('slicktheme','/wp-content/themes/handlpartners/assets/vendor/slick/slick-theme.css', array('slick'),'1.5.9');
	wp_register_style('fancybox','/wp-content/themes/handlpartners/assets/vendor/fancybox/jquery.fancybox.css', array(),'2.1.5');
	wp_register_style('handlpartners','/wp-content/themes/handlpartners/style.css', array('foundation','slick'),$version);

    wp_enqueue_style('fontawesome');
    wp_enqueue_style('webtype');
	wp_enqueue_style('foundation');
	wp_enqueue_style('motion-ui');
	wp_enqueue_style('slick');
	wp_enqueue_style('slicktheme');
	wp_enqueue_style('fancybox');
	wp_enqueue_style('handlpartners');

	wp_register_script('wurfl','//wurfl.io/wurfl.js', array(),'1.0.0', false);
	wp_register_script('easing','//cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.3/jquery.easing.min.js', array('jquery'), '1.3.0', false);
	wp_register_script('handlebars','//cdnjs.cloudflare.com/ajax/libs/handlebars.js/4.0.5/handlebars.min.js', array(), '4.0.5', false);
    wp_register_script('jquery','/wp-content/themes/handlpartners/assets/vendor/jquery/dist/jquery.min.js', array(),'2.1.4', false);
    wp_register_script('whatinput','/wp-content/themes/handlpartners/assets/vendor/what-input/what-input.min.js', array('jquery'),'1.0', true);
	wp_register_script('foundation','/wp-content/themes/handlpartners/assets/vendor/foundation-sites/dist/foundation.js', array('jquery','whatinput'),'6.0', true);
	wp_register_script('motion-ui','/wp-content/themes/handlpartners/assets/vendor/motion-ui/dist/motion-ui.min.js', array('jquery','foundation'),'6.0', true);
	wp_register_script('slick','/wp-content/themes/handlpartners/assets/vendor/slick/slick.js', array('jquery'),'1.5.9', true);
	wp_register_script('packery','/wp-content/themes/handlpartners/assets/vendor/metafizzy/packery.pkgd.min.js', array('jquery'),'2.0.0', true);
	wp_register_script('fancybox','/wp-content/themes/handlpartners/assets/vendor/fancybox/jquery.fancybox.pack.js', array('jquery'),'2.1.5', true);
	wp_register_script('handlpartners','/wp-content/themes/handlpartners/assets/js/app.js', array('foundation','jquery'),$version, true);

	wp_enqueue_script('wurfl');
	wp_enqueue_script('easing');
	wp_enqueue_script('handlebars');
    wp_enqueue_script('jquery');
    wp_enqueue_script('whatinput');
	wp_enqueue_script('foundation');
	wp_enqueue_script('motion-ui');
	wp_enqueue_script('slick');
	wp_enqueue_script('packery');
	wp_enqueue_script('fancybox');
	wp_enqueue_script('handlpartners');
}
add_action('wp_enqueue_scripts','hlp_scripts');

//============================================================
// Custom Page Routes
//============================================================

function hlp_rewrites_init(){
	//=======================================================================
	//Anytime these are updated, go to the permalinks admin page and hit SAVE
	//=======================================================================

	//White Papers
	add_rewrite_rule('^what-we-do/white-papers/([^/]*)/([^/]*)/?','index.php?pagename=what-we-do/white-papers&display_mode=pardot&pardot_data=$matches[1]&pardot_office=$matches[2]','top');
	add_rewrite_rule('^what-we-do/white-papers/([^/]*)/?','index.php?pagename=what-we-do/white-papers&display_mode=pardot&pardot_data=$matches[1]&pardot_office=','top');
	add_rewrite_rule('^what-we-do/white-papers/?','index.php?pagename=what-we-do/white-papers&display_mode=pardot&pardot_data=&pardot_office=','top');

	//Viewpoint Access
	add_rewrite_rule('^what-we-do/viewpoint-access/([^/]*)/?','index.php?pagename=what-we-do/viewpoint-access&display_mode=pardot&pardot_data=$matches[1]','top');
	add_rewrite_rule('^what-we-do/viewpoint-access/?','index.php?pagename=what-we-do/viewpoint-access&display_mode=pardot&pardot_data=','top');

	//Viewpoint Thank You
	add_rewrite_rule('^what-we-do/viewpoint-thank-you/([^/]*)/?','index.php?pagename=what-we-do/viewpoint-thank-you&display_mode=pardot&pardot_data=$matches[1]','top');
	add_rewrite_rule('^what-we-do/viewpoint-thank-you/?','index.php?pagename=what-we-do/viewpoint-thank-you&display_mode=pardot&pardot_data=','top');

	//Pardot Forms
	add_rewrite_rule('^pardot-frame/([^/]*)/success/?','index.php?pagename=pardot-frame&display_mode=pardot&pardot_data=$matches[1]&pardot_success=success','top');
	add_rewrite_rule('^pardot-frame/([^/]*)/?','index.php?pagename=pardot-frame&display_mode=pardot&pardot_data=$matches[1]&pardot_success=form','top');
	add_rewrite_rule('^pardot-frame/?','index.php?pagename=pardot-frame&display_mode=pardot&pardot_data=&pardot_success=form','top');

	//Private Case Studies
	add_rewrite_rule('^case-studies/([^/]*)/?','index.php?pagename=case-studies&display_mode=detail&case_slug=$matches[1]','top');
	add_rewrite_rule('^case-studies/?','index.php?pagename=case-studies&display_mode=list&case_slug=','top');	

	//Case Studies
	add_rewrite_rule('^what-we-do/case-studies-thank-you/([^/]*)/?','index.php?pagename=what-we-do/case-studies-thank-you&display_mode=detail&case_slug=$matches[1]','top');
	add_rewrite_rule('^what-we-do/case-studies/([^/]*)/?','index.php?pagename=what-we-do/case-studies&display_mode=detail&case_slug=$matches[1]','top');
	add_rewrite_rule('^what-we-do/case-studies/?','index.php?pagename=what-we-do/case-studies&display_mode=list&case_slug=','top');

	//Jobs Board
	add_rewrite_rule('^contact/join-us/([^/]*)/?','index.php?pagename=contact/join-us&display_mode=detail&job_slug=$matches[1]','top');
	add_rewrite_rule('^contact/join-us/?','index.php?pagename=contact/join-us&display_mode=list&job_slug=','top');

	//Invalid Work Types
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/([^/]*)/([^/]*)/([^/]*)/(broadcast|print|digital|non-trad)/?','index.php?pagename=our-work&display_mode=type-redirect&type=$matches[1]&client=$matches[2]&campaign=$matches[3]&project=$matches[4]&media=$matches[5]','top');
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/([^/]*)/([^/]*)/(broadcast|print|digital|non-trad)/?','index.php?pagename=our-work&display_mode=type-redirect&type=$matches[1]&client=$matches[2]&campaign=$matches[3]&media=$matches[4]','top');
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/([^/]*)/(broadcast|print|digital|non-trad)/?','index.php?pagename=our-work&display_mode=type-redirect&type=$matches[1]&client=$matches[2]&media=$matches[3]','top');

	//Work Types + Filters
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/(broadcast|print|digital|non-trad)/([^/]*)/([^/]*)/([^/]*)/?','index.php?pagename=our-work&display_mode=type-media&type=$matches[1]&media=$matches[2]&client=$matches[3]&campaign=$matches[4]&project=$matches[5]','top');
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/(broadcast|print|digital|non-trad)/([^/]*)/([^/]*)/?','index.php?pagename=our-work&display_mode=type-media&type=$matches[1]&media=$matches[2]&client=$matches[3]&campaign=$matches[4]','top');
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/(broadcast|print|digital|non-trad)/([^/]*)/?','index.php?pagename=our-work&display_mode=type-media&type=$matches[1]&media=$matches[2]&client=$matches[3]','top');
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/(broadcast|print|digital|non-trad)/?','index.php?pagename=our-work&display_mode=type-media&type=$matches[1]&media=$matches[2]','top');

	//Wildcard Work Types
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/([^/]*)/([^/]*)/([^/]*)/?','index.php?pagename=our-work&display_mode=type-client&type=$matches[1]&client=$matches[2]&campaign=$matches[3]&project=$matches[4]','top');
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/([^/]*)/([^/]*)/?','index.php?pagename=our-work&display_mode=type-client&type=$matches[1]&client=$matches[2]&campaign=$matches[3]','top');
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/([^/]*)/?','index.php?pagename=our-work&display_mode=type-client&type=$matches[1]&client=$matches[2]','top');
	add_rewrite_rule('^our-work/(destination-travel|franchise-retail)/?','index.php?pagename=our-work&display_mode=type&type=$matches[1]','top');

	//Work Media Types
	add_rewrite_rule('^our-work/(broadcast|print|digital|non-trad)/([^/]*)/([^/]*)/([^/]*)/?','index.php?pagename=our-work&display_mode=media&media=$matches[1]&client=$matches[2]&campaign=$matches[3]&project=$matches[4]','top');
	add_rewrite_rule('^our-work/(broadcast|print|digital|non-trad)/([^/]*)/([^/]*)/?','index.php?pagename=our-work&display_mode=media&media=$matches[1]&client=$matches[2]&campaign=$matches[3]','top');
	add_rewrite_rule('^our-work/(broadcast|print|digital|non-trad)/([^/]*)/?','index.php?pagename=our-work&display_mode=media&media=$matches[1]&client=$matches[2]','top');
	add_rewrite_rule('^our-work/(broadcast|print|digital|non-trad)/?','index.php?pagename=our-work&display_mode=media&media=$matches[1]','top');

	//Work Offices
	add_rewrite_rule('^our-work/(san-francisco|st-louis|boston|richmond)/?','index.php?pagename=our-work&display_mode=office&office=$matches[1]','top');

	//Work Utilities
	add_rewrite_rule('^our-work/filter/?','index.php?pagename=our-work/filter','top');
	add_rewrite_rule('^our-work/debug/?','index.php?pagename=our-work/debug','top');

	//Invalid Wildcards
	add_rewrite_rule('^our-work/([^/]*)/([^/]*)/([^/]*)/(broadcast|print|digital|non-trad)/?','index.php?pagename=our-work&display_mode=filter-redirect&client=$matches[1]&campaign=$matches[2]&project=$matches[3]&media=$matches[4]','top');
	add_rewrite_rule('^our-work/([^/]*)/([^/]*)/(broadcast|print|digital|non-trad)/?','index.php?pagename=our-work&display_mode=filter-redirect&client=$matches[1]&campaign=$matches[2]&media=$matches[3]','top');
	add_rewrite_rule('^our-work/([^/]*)/(broadcast|print|digital|non-trad)/?','index.php?pagename=our-work&display_mode=filter-redirect&client=$matches[1]&media=$matches[2]','top');

	//Work Wildcards
	add_rewrite_rule('^our-work/([^/]*)/([^/]*)/([^/]*)/?','index.php?pagename=our-work&display_mode=filter&client=$matches[1]&campaign=$matches[2]&project=$matches[3]','top');
	add_rewrite_rule('^our-work/([^/]*)/([^/]*)/?','index.php?pagename=our-work&display_mode=filter&client=$matches[1]&campaign=$matches[2]','top');
	add_rewrite_rule('^our-work/([^/]*)/?','index.php?pagename=our-work&display_mode=filter&client=$matches[1]','top');
	add_rewrite_rule('^our-work/?','index.php?pagename=our-work&display_mode=home','top');

	//=======================================================================
	//Anytime these are updated, go to the permalinks admin page and hit SAVE
	//=======================================================================
}
add_action('init','hlp_rewrites_init');

function hlp_query_vars($query_vars){
	//Add the query vars from our rewrites
	$query_vars[] = 'display_mode';
	$query_vars[] = 'case_slug';
	$query_vars[] = 'job_slug';
	$query_vars[] = 'pardot_data';
	$query_vars[] = 'pardot_office';
	$query_vars[] = 'pardot_success';

	$query_vars[] = 'type';
	$query_vars[] = 'media';
	$query_vars[] = 'office';
	$query_vars[] = 'client';
	$query_vars[] = 'campaign';
	$query_vars[] = 'project';

	return $query_vars;
}
add_filter('query_vars','hlp_query_vars');

//============================================================
// Load Additional Methods
//============================================================

function hlp_load_functions($file=""){
	if( file_exists(TEMPLATEPATH . "/functions/functions-{$file}.php") ){
		include_once(TEMPLATEPATH . "/functions/functions-{$file}.php");
	}
}

include_once(TEMPLATEPATH . "/functions/functions-shortcodes.php");
include_once(TEMPLATEPATH . "/functions/functions-helpers.php");
include_once(TEMPLATEPATH . "/functions/functions-triggers.php");

if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest'){
	include_once(TEMPLATEPATH . "/functions/functions-ajax.php");
}

//============================================================
// EOF
//============================================================
