<?php
/**
 * H&L Partners data functions
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since Version 1.0
 */

//============================================================
// Home Page Slides
//============================================================

function hlp_home_slides(){
	$query = new WP_Query(array(
		'post_type'       => 'hlp-homeslides',
		'post_status'     => 'publish',
		'posts_per_page'  => -1,
		'orderby'         => 'menu_order',
		'order'           => 'DESC',
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();
			$slide 				= (object) array();
			$slide->title 		= types_render_field("title-1", array("output"=>"raw"));
			$slide->subtitle 	= types_render_field("title-2", array("output"=>"raw"));
			$slide->image 		= types_render_field("slide-background", array("output"=>"raw"));
			$slide->url 			= types_render_field("slide-url", array("output"=>"raw"));
			$slide->button 		= types_render_field("slide-url-button", array("output"=>"raw"));
			$slide->target 		= types_render_field("slide-url-target", array("output"=>"raw"));

			if( empty($slide->button) ) $slide->button = "View More";
			if( empty($slide->target) ) $slide->target = "_self";

			//Filter for McD's name format
			$slide->title = str_replace("MCD","McD",strtoupper($slide->title));

			include(TEMPLATEPATH . "/includes/home/slideshow.php");
		}
	}

	wp_reset_query();
}

//============================================================
// People
//============================================================

function hlp_people(){
	$people = array();
	$query = new WP_Query(array(
		'post_type'       => 'hlp-people',
		'post_status'     => 'publish',
		'posts_per_page'  => -1,
		'orderby'         => 'menu_order',
		'order'           => 'DESC',
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();
			$person          = (object) array();
			$person->name 	 = get_the_title();
			$person->title 	 = types_render_field("people-title", array("output"=>"raw"));
			$person->bio 	 = types_render_field("people-bio", array("output"=>"raw"));
			$person->photo 	 = types_render_field("people-photo", array("output"=>"raw"));
			$people[]        = $person;
		}
	}

	wp_reset_query();
	include(TEMPLATEPATH . "/includes/about-us/people.php");
}

//============================================================
// Services
//============================================================

function hlp_services(){
	$services = array();
	$query = new WP_Query(array(
		'post_type'       => 'hlp-services',
		'post_status'     => 'publish',
		'posts_per_page'  => -1,
		'orderby'         => 'menu_order',
		'order'           => 'DESC',
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();
			$service                 = (object) array();
			$service->title          = get_the_title();
			$service->description    = types_render_field("service-description", array("output"=>"raw"));
			$services[]              = $service;
		}
	}

	wp_reset_query();
	include(TEMPLATEPATH . "/includes/what-we-do/services.php");
}

//============================================================
// Case Studies
//============================================================

function hlp_case_studies($mode='franchise-retail',$posts=-1){
	$studies = array();
	$query = new WP_Query(array(
		'post_type'       => 'hlp-casestudies',
		'post_status'     => 'publish',
		'posts_per_page'  => $posts,
		'orderby'         => 'menu_order',
		'order'           => 'DESC',
		'tax_query'       => array(array('taxonomy' => 'case-study-categories','field' => 'slug','terms' => $mode))
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();

			$case 					= (object) array();
			$case->id 				= get_the_ID();
			$case->url 				= get_the_permalink();
			$case->title 			= get_the_title();
			$case->featured_image 	= wp_get_attachment_url( get_post_thumbnail_id(get_the_id()) );
			$case->quote 			= types_render_field("case-study-quote", array("output"=>"raw"));

			$client_id = wpcf_pr_post_get_belongs($case->id,"hlp-clients");
            $client = get_post($client_id);

			$case->client 			= (object) array();
			$case->client->id 		= $client_id;
            $case->client->slug 	= $client->post_name;
            $case->client->name 	= get_post_meta($client_id,"wpcf-client-name",TRUE);
			$case->client->local 	= get_post_meta($client_id,"wpcf-client-local-name",TRUE);
            $case->client->logo 	= get_post_meta($client_id,"wpcf-client-logo",TRUE);

			$campaign_id = wpcf_pr_post_get_belongs($case->id,"hlp-campaigns");
            $campaign = get_post($campaign_id);

			$case->campaign         			= (object) array();
			$case->campaign->id               	= $campaign_id;
			$case->campaign->slug             	= $campaign->post_name;
			$case->campaign->title            	= get_post_meta($campaign_id,"wpcf-campaign-title",TRUE);
			$case->campaign->description      	= get_post_meta($campaign_id,"wpcf-campaign-description",TRUE);

			$case->campaign->icons            	= (object) array();
			$case->campaign->icons->square    	= get_post_meta($campaign_id,"wpcf-square-icon",TRUE);
			$case->campaign->icons->large     	= get_post_meta($campaign_id,"wpcf-large-icon",TRUE);

			$studies[] = $case;
		}
	}

	wp_reset_query();
	include(TEMPLATEPATH . "/includes/what-we-do/case-studies.php");
}

function hlp_case_studies_detail($slug="",$return=FALSE,$shownav=TRUE){
	$case = (object) array();
	$query = new WP_Query(array(
		'post_type'   => 'hlp-casestudies',
		'post_status' => 'publish',
		'name'        => $slug
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();

			$case->id 				= get_the_ID();
			$case->url 				= get_the_permalink();
			$case->slug				= $slug;
			$case->title 			= get_the_title();
			$case->featured_image 	= wp_get_attachment_url( get_post_thumbnail_id(get_the_id()) );
			$case->background 		= types_render_field("case-study-background-copy", array("output"=>"html"));
			$case->create 			= types_render_field("case-study-create-copy", array("output"=>"html"));
			$case->deploy 			= types_render_field("case-study-deploy-copy", array("output"=>"html"));
			$case->deliver 			= types_render_field("case-study-deliver-copy", array("output"=>"html"));
			$case->quote 			= types_render_field("case-study-quote", array("output"=>"raw"));
			$case->download 		= types_render_field("case-study-download", array("output"=>"raw"));

			$client_id = wpcf_pr_post_get_belongs($case->id,"hlp-clients");
            $client = get_post($client_id);

			$case->client 			= (object) array();
			$case->client->id 		= $client_id;
            $case->client->slug 	= $client->post_name;
            $case->client->name 	= get_post_meta($client_id,"wpcf-client-name",TRUE);
			$case->client->local 	= types_render_field("case-study-client", array("output"=>"raw"));
            $case->client->logo 	= get_post_meta($client_id,"wpcf-client-logo",TRUE);

			$campaign_id = wpcf_pr_post_get_belongs($case->id,"hlp-campaigns");
            $campaign = get_post($campaign_id);

			$case->campaign         			= (object) array();
			$case->campaign->id               	= $campaign_id;
			$case->campaign->slug             	= $campaign->post_name;
			$case->campaign->title            	= get_post_meta($campaign_id,"wpcf-campaign-title",TRUE);
			$case->campaign->description      	= get_post_meta($campaign_id,"wpcf-campaign-description",TRUE);

			$case->campaign->icons            	= (object) array();
			$case->campaign->icons->square    	= get_post_meta($campaign_id,"wpcf-square-icon",TRUE);
			$case->campaign->icons->large     	= get_post_meta($campaign_id,"wpcf-large-icon",TRUE);

			$case->media 	= array();
			$case->images 	= array();
			$case->slides 	= array();

			$media = get_post_meta(get_the_ID(),'wpcf-case-study-vimeo-ids');
			foreach($media as $key => $vid){
				if( !empty($vid) ){
					global $wpdb;

					$caption = "";
					if(strpos($vid,'|') !== FALSE){
						$parts = explode("|",$vid);
						$vid = trim($parts[0]);
						$caption = trim($parts[1]);
					}

					$pkg = (object) array();
					$pkg->id = $vid;
					$pkg->caption = $caption;

					$sql = "SELECT vimeo_url FROM vimeo_cache WHERE vimeo_id = '$vid'";
					$thumb = $wpdb->get_var($sql);

					if( !empty($thumb) ){
						$pkg->thumb = $thumb;
					} else {
						$url = urlencode('http://vimeo.com/' . $vid);
						$data  = curl_fetch_data("http://vimeo.com/api/oembed.json?url=$url");

						if( !empty($data) ){
							$data  = json_decode($data);
							if( isset($data->thumbnail_url) ){
								$pkg->thumb = $data->thumbnail_url;
								$wpdb->replace("vimeo_cache",array("vimeo_id" => $vid, "vimeo_url" => $pkg->thumb));
							}
						}
					}

					$case->media[] = $pkg;
				}
			}

			$youtube = get_post_meta(get_the_ID(),'wpcf-case-study-youtube-ids');
			foreach($youtube as $key => $vid){
				if( !empty($vid) ){
					global $wpdb;

					$caption = "";
					if(strpos($vid,'|') !== FALSE){
						$parts = explode("|",$vid);
						$vid = trim($parts[0]);
						$caption = trim($parts[1]);
					}

					$pkg = (object) array();
					$pkg->id = $vid;
					$pkg->caption = $caption;

					$sql = "SELECT vimeo_url FROM vimeo_cache WHERE vimeo_id = '$vid'";
					$thumb = $wpdb->get_var($sql);

					if( !empty($thumb) ){
						$pkg->thumb = $thumb;
					} else {
						$thumb = "http://img.youtube.com/vi/{$vid}/default.jpg";
						$exists = remote_url_exists($thumb);
						if($exists){
							$wpdb->replace("vimeo_cache",array("vimeo_id" => $vid, "vimeo_url" => $thumb));
						}
					}

					$case->media[] = $pkg;
				}
			}

			$images = get_post_meta(get_the_ID(),'wpcf-case-study-featured-images');
			foreach($images as $key => $img){
				$meta = hlp_case_studies_meta($img);
				if(!empty($meta)) $case->images[] = $meta;
			}

			$slides = get_post_meta(get_the_ID(),'wpcf-case-study-slide-images');
			foreach($slides as $key => $img){
				$meta = hlp_case_studies_meta($img);
				if(!empty($meta)) $case->slides[] = $meta;
			}
		}
	}

	wp_reset_query();

	if($return === TRUE) return $case;

	if($shownav === TRUE){ 
		$case->loop = hlp_case_studies_loop($slug);
		include(TEMPLATEPATH . "/includes/what-we-do/case-studies-detail.php");
	} else {
		$case->loop = FALSE;
		include(TEMPLATEPATH . "/includes/what-we-do/case-studies-detail-unlisted.php");
	}
}

function remote_url_exists($url){
    $ch = curl_init($url);    
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if($code == 200){
		$status = true;
    }else{
		$status = false;
    }

    curl_close($ch);
	return $status;
}

function hlp_case_studies_loop($current=""){
	$loop = (object) array();
	$loop->prev = "";
	$loop->next = "";
	$collection = array();

	$id = hlp_get_post_id($current);
	$cats = get_the_terms($id,'case-study-categories');
	$cat_list = array();

	foreach($cats as $cat){
		$cat_list[] = $cat->slug;
	}

	$query = new WP_Query(array(
		'post_type'       => 'hlp-casestudies',
		'post_status'     => 'publish',
		'posts_per_page'  => -1,
		'orderby'         => 'menu_order',
		'order'           => 'DESC',
		'tax_query'       => array(array('taxonomy' => 'case-study-categories','field' => 'slug','terms' => $cat_list))
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();
			$entry           = (object) array();
			$entry->url      = get_the_permalink();
			$entry->slug     = basename($entry->url);
			$collection[]    = $entry;
		}
	}

	$index = 0;
	foreach($collection as $entry){
		if($entry->slug === $current){
			$prev = $index - 1;
			if($prev < 0) $prev = count($collection) - 1;
			$next = $index + 1;
			if($next > (count($collection) - 1)) $next = 0;
			$loop->prev = $collection[$prev];
			$loop->next = $collection[$next];
			break;
		}
		$index++;
	}

	wp_reset_query();
	return $loop;
}

function hlp_case_studies_meta($image_url){
	global $wpdb;
	$meta = array();

	if(!empty($image_url)){
		$image = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE guid='%s';",$image_url));
		if(!empty($image)){
			$meta = (object) array(
				'src'       => $image_url,
				'title'     => $image->post_name,
				'desc'      => $image->post_content,
				'caption'   => $image->post_excerpt,
				'alt'       => get_post_meta($image->ID,'_wp_attachment_image_alt',true)
			);
		}
	}

	return $meta;
}

//============================================================
// Locations
//============================================================

function hlp_locations(){
	$locations = array();
	$query = new WP_Query(array(
		'post_type'       => 'hlp-locations',
		'post_status'     => 'publish',
		'posts_per_page'  => -1,
		'orderby'         => 'menu_order',
		'order'           => 'DESC',
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
            $query->the_post();
            $location              = (object) array();
            $location->title 		 = get_the_title();
            $location->address1 	 = types_render_field("location-address-1", array("output"=>"raw"));
            $location->address2 	 = types_render_field("location-address-2", array("output"=>"raw"));
            $location->phone       = types_render_field("location-phone", array("output"=>"raw"));
            $location->image       = types_render_field("location-map", array("output"=>"raw"));
            $location->googlemap   = types_render_field("location-map-url", array("output"=>"raw"));
            $location->contact     = types_render_field("location-contact", array("output"=>"raw"));
            $location->display     = types_render_field("location-display", array("output"=>"raw"));
            $locations[]           = $location;
		}
	}

	wp_reset_query();
	include(TEMPLATEPATH . "/includes/contact/locations.php");
}

//============================================================
// Jobs Board
//============================================================

function hlp_jobs_board(){
	$jobs = array();
	$query = new WP_Query(array(
		'post_type'       => 'hlp-jobs',
		'post_status'     => 'publish',
		'posts_per_page'  => -1,
		'orderby'         => 'date',
		'order'           => 'DESC',
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();
			$job             = (object) array();
			$job->title      = get_the_title();
            $job->link       = get_the_permalink();
			$job->date 	     = types_render_field("posting-date", array("output"=>"raw"));
            $job->office     = types_render_field("office", array("output"=>"raw"));
            $job->job        = types_render_field("job-title", array("output"=>"raw"));
            $job->details    = types_render_field("job-details", array("output"=>"html"));
			$jobs[]          = $job;
		}
	}

	wp_reset_query();
	include(TEMPLATEPATH . "/includes/contact/join-us.php");
}

function hlp_jobs_detail($slug=""){
    $job = (object) array();
	$query 	= new WP_Query(array(
		'post_type'   => 'hlp-jobs',
		'post_status' => 'publish',
		'name'        => $slug
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();
            $job->title      = get_the_title();
			$job->date 	     = types_render_field("posting-date", array("output"=>"raw"));
            $job->office     = types_render_field("office", array("output"=>"raw"));
            $job->job        = types_render_field("job-title", array("output"=>"raw"));
            $job->details    = types_render_field("job-details", array("output"=>"html"));
		}
	}

	wp_reset_query();
	include(TEMPLATEPATH . "/includes/contact/join-us-details.php");
}

//============================================================
// Work Menus
//============================================================

function hlp_types_menu(){
    $types = array(
        "destination-travel"    => "Destination Travel",
        "franchise-retail"      => "Retail/Franchise"
    );
    include(TEMPLATEPATH . "/includes/navigation/navigation-work-types.php");
}

function hlp_media_menu($data=FALSE){
    $mediums = array(
        "broadcast" => "Broadcast",
        "digital"   => "Digital",
        "print"     => "Print",
        "non-trad"  => "Non-Trad"
    );

    $found = array();
    if( !empty($_SESSION["client"]) ){
        $client = hlp_get_client_by_slug($_SESSION["client"],FALSE);
        $projects = hlp_client_projects($client);
        foreach($projects as $project){
            $terms = wp_get_post_terms($project->id,"media");
            foreach($terms as $term){
                $found[$term->slug] = $term->name;
            }
        }
        $mediums = $found;
    }

    if($data === TRUE) return $mediums;
	if( !empty($mediums) ) include(TEMPLATEPATH . "/includes/navigation/navigation-work-media.php");
}

function hlp_clients_menu(){
    $args = array(
		'post_type'   => 'hlp-clients',
        'post_status' => 'publish',
		'nopaging'    => TRUE,
		'orderby'     => 'menu_order',
		'order'       => 'ASC',
	);
    if( !empty($_SESSION["type"]) ){
        $args['tax_query'] = array(
            array('taxonomy' => 'client-types','field' => 'slug','terms' => $_SESSION['type'])
        );
    }

    $clients = array();
    $clients_list = array();
	$query = new WP_Query($args);

    // Gather all clients based on initial filter
	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();
            $client             = (object) array();
            $client->slug       = basename(get_the_permalink());
            $client->name       = types_render_field("client-name", array("output"=>"raw"));
            $client->campaigns  = hlp_client_campaigns(get_the_ID());
            $clients_list[]     = $client;
		}
	}

    // Gather all clients with projects
    foreach($clients_list as $client){
        $counter = 0;
        foreach($client->campaigns as $campaign){
            if( count($campaign->projects) > 0 ) $counter++;
        }
        if($counter > 0) $clients[] = $client;
    }

	wp_reset_query();
	if( !empty($clients) ) include(TEMPLATEPATH . "/includes/navigation/navigation-work-clients.php");
}

function hlp_campaigns_menu(){
    if( !empty($_SESSION["client"]) ){
        $client = hlp_get_client_by_slug($_SESSION["client"],TRUE);
        $campaigns = array();
        $campaigns_list = $client->campaigns;

        foreach($campaigns_list as $campaign){
            if( count($campaign->projects) > 0 ) $campaigns[] = $campaign;
        }

        if( !empty($campaigns) ) include(TEMPLATEPATH . "/includes/navigation/navigation-work-campaigns.php");
    }
}

//============================================================
// Client Models
//============================================================

function hlp_get_client_by_id($id="",$campaigns=FALSE){
    $client = FALSE;

    if( !empty($id) ){
        $args = array(
            'post_type'     => 'hlp-clients',
            'post_status'   => 'publish',
            'numberposts'   => 1,
            'p'             => $id
        );
        $posts = get_posts($args);

        foreach($posts as $post){
            $client                 = (object) array();
            $client->id             = $post->ID;
            $client->slug           = $post->post_name;
            $client->name           = get_post_meta($post->ID,"wpcf-client-name",TRUE);
            $client->logo           = get_post_meta($post->ID,"wpcf-client-logo",TRUE);
            $client->banner         = get_post_meta($post->ID,"wpcf-client-banner",TRUE);
            $client->description    = get_post_meta($post->ID,"wpcf-client-description",TRUE);

            if($campaigns) $client->campaigns = hlp_client_campaigns($post->ID);
        }
    }

    return $client;
}

function hlp_get_client_by_slug($slug="",$campaigns=FALSE){
    $client = FALSE;

    if( !empty($slug) ){
        $args = array(
            'post_type'     => 'hlp-clients',
            'post_status'   => 'publish',
            'numberposts'   => 1,
            'name'          => $slug
        );
        $posts = get_posts($args);

        foreach($posts as $post){
            $client                 = (object) array();
            $client->id             = $post->ID;
            $client->slug           = $post->post_name;
            $client->name           = get_post_meta($post->ID,"wpcf-client-name",TRUE);
            $client->logo           = get_post_meta($post->ID,"wpcf-client-logo",TRUE);
            $client->banner         = get_post_meta($post->ID,"wpcf-client-banner",TRUE);
            $client->description    = get_post_meta($post->ID,"wpcf-client-description",TRUE);

            if($campaigns) $client->campaigns = hlp_client_campaigns($post->ID);
        }
	}

    return $client;
}

function hlp_client_campaigns($id){
    $campaigns = array();

    if( !empty($id) ){
        $args = array(
            'post_type'     => 'hlp-campaigns',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
            'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-clients_id','value' => $id)),
            'nopaging'      => TRUE
        );
        $posts = get_posts($args);

        foreach($posts as $post){
            $campaign                   = (object) array();
            $campaign->id               = $post->ID;
            $campaign->slug             = $post->post_name;
            $campaign->title            = get_post_meta($post->ID,"wpcf-campaign-title",TRUE);
            $campaign->description      = get_post_meta($post->ID,"wpcf-campaign-description",TRUE);

            $campaign->icons            = (object) array();
            $campaign->icons->square    = get_post_meta($post->ID,"wpcf-square-icon",TRUE);
            $campaign->icons->large     = get_post_meta($post->ID,"wpcf-large-icon",TRUE);

			$campaign->client           = hlp_get_client_by_id($id);
            $campaign->projects         = hlp_campaign_projects($campaign);

            $campaigns[]                = $campaign;
        }
    }

    return $campaigns;
}

function hlp_client_projects($client){
    $projects = array();

    if( !empty($client) ){
        $args = array(
            'post_type'     => 'hlp-projects',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
			'nopaging'      => TRUE,
            'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-clients_id','value' => $client->id))
        );
        $posts = get_posts($args);

        foreach($posts as $post){
            $project        = (object) array();
            $project->id    = $post->ID;
            $project->slug  = $post->post_name;
            $project->title = get_post_meta($post->ID,"wpcf-project-title",TRUE);
            $projects[]     = $project;
        }
    }

    return $projects;
}

function hlp_campaign_projects($campaign){
    $projects = array();

    if( !empty($campaign) ){
        $args = array(
            'post_type'     => 'hlp-projects',
            'post_status'   => 'publish',
            'orderby'       => 'menu_order',
            'order'         => 'ASC',
			'nopaging'      => TRUE,
            'meta_query'    => array(array('key' => '_wpcf_belongs_hlp-campaigns_id','value' => $campaign->id))
        );
        if( !empty($_SESSION['media']) ){
            $args['tax_query'] = array(array('taxonomy' => 'media','field' => 'slug','terms' => $_SESSION['media']));
        }
        $posts = get_posts($args);

        foreach($posts as $post){
            $project                    = (object) array();
            $project->id                = $post->ID;
            $project->slug              = $post->post_name;

            $project->title             = get_post_meta($post->ID,"wpcf-project-title",TRUE);
            $project->thumbnail         = get_post_meta($post->ID,"wpcf-project-thumbnail",TRUE);
            $project->photo             = get_post_meta($post->ID,"wpcf-project-photo",TRUE);
            $project->vimeo             = get_post_meta($post->ID,"wpcf-vimeo-id",TRUE);
            $project->iframe            = get_post_meta($post->ID,"wpcf-iframe-url",TRUE);
            $project->url               = get_post_meta($post->ID,"wpcf-external-url",TRUE);

			$project->campaign          = (object) array();
            $project->campaign->id      = $campaign->id;
            $project->campaign->title   = $campaign->title;

            $projects[]                 = $project;
        }
    }

    return $projects;
}

//============================================================
// News Models
//============================================================

function hlp_get_news_by_category($cat="",$limit=3){
	if( !empty($cat) ){
        $args = array(
            'post_type'     	=> 'post',
            'post_status'   	=> 'publish',
            'orderby'       	=> 'post_date',
            'order'         	=> 'DESC',
			'posts_per_page'  	=> $limit
        );
		if($cat !== "mixed") $args['category_name'] = $cat;
        $query = new WP_Query($args);

		if( $query->have_posts() ){
			while( $query->have_posts() ){
				$query->the_post();
				include(TEMPLATEPATH . "/includes/news/excerpts.php");
			}
		}

		wp_reset_query();
    }
}

//============================================================
// GoZone
//============================================================

function hlp_gozone_excerpt($text=""){
	if ( '' != $text ) {
		$text = strip_shortcodes( $text );
		$text = apply_filters('the_content', $text);
		$text = str_replace(']]>', ']]>', $text);
		$excerpt_length = 26; // 20 words
		$excerpt_more = apply_filters('excerpt_more', ' ' . '[...]');
		$text = wp_trim_words( $text, $excerpt_length, $excerpt_more );
	}
	return apply_filters('the_excerpt', $text);
}

function hlp_gozone($mode='franchise-retail',$limit=5){
	$papers = array();
	$query = new WP_Query(array(
		'post_type'       => 'hlp-whitepaper',
		'post_status'     => 'publish',
		'orderby'         => 'post_date',
		'order'           => 'DESC',
		'posts_per_page'  => -1,
		'tax_query'       => array(array('taxonomy' => 'case-study-categories','field' => 'slug','terms' => $mode))
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();

			$paper 				= (object) array();
			$paper->id 			= get_the_ID();
			$paper->url 		= get_the_permalink();
			$paper->title 		= get_the_title();
			$paper->date		= get_the_date("m/d/Y");
			$paper->image 		= wp_get_attachment_url( get_post_thumbnail_id(get_the_id()) );
			$paper->details 	= types_render_field("white-paper-details", array("output"=>"raw"));
			$paper->excerpt		= hlp_gozone_excerpt($paper->details);

			$papers[] = $paper;
		}
	}

	wp_reset_query();
	include(TEMPLATEPATH . "/includes/what-we-do/gozone.php");
}

function hlp_gozone_details($slug=""){
	$paper = array();

	if( !empty($slug) ){
		$query = new WP_Query(array(
			'post_type'     => 'hlp-whitepaper',
			'post_status'   => 'publish',
			'numberposts'   => 1,
            'name'          => $slug
		));

		if( $query->have_posts() ){
			while( $query->have_posts() ){
				$query->the_post();

				$paper 					= (object) array();
				$paper->id 				= get_the_ID();
				$paper->url 			= get_the_permalink();
				$paper->title 			= get_the_title();
				$paper->date			= get_the_date("m/d/Y");
				$paper->image 			= wp_get_attachment_url( get_post_thumbnail_id(get_the_id()) );
				$paper->details 		= types_render_field("white-paper-details", array("output"=>"html"));
				$paper->download 		= types_render_field("white-paper-download", array("output"=>"raw"));
				$paper->email_download 	= types_render_field("pardot-email-download", array("output"=>"raw"));
				$paper->contact 		= types_render_field("primary-contact", array("output"=>"raw"));
			}
		}

		wp_reset_query();
	}

	return $paper;
}

//============================================================
// EOF
//============================================================
