
<div id="work-tiles-outer" class="clearfix">
    <div id="work-tiles-inner" class="clearfix">
        <?php
            foreach($campaigns as $campaign):

            $rand = rand(0,1);
    		if($rand === 1){
    			$size = "square";
    			$thumb = $campaign->icons->square;
    		} else {
    			$size = "horz";
    			$thumb = $campaign->icons->large;
    		}

            $paths = array("our-work");
            if( !empty($_SESSION["type"]) ) $paths[] = $_SESSION["type"];
            if( !empty($_SESSION["media"]) ) $paths[] = $_SESSION["media"];
            $paths = implode($paths,"/");
        ?>

        <a href="/<?php echo $paths;?>/<?php echo @$campaign->client->slug;?>/<?php echo @$campaign->slug;?>/" class="proj <?php echo $size;?>">
    		<img src="<?php echo $thumb;?>">
    		<span class="tile-title"><b><?php echo @$campaign->client->name;?></b><br><?php echo @$campaign->title;?></span>
    		<span class="tile-corner">
    			<img src="<?php echo get_template_directory_uri(); ?>/assets/img/hl_plus_rollover_green.png">
    		</span>
    	</a>

        <?php endforeach; ?>
    </div>
</div>

<div id="work-viewer-more" style="display:none">View More</div>

<script>
    jQuery(document).ready(function(){
        	jQuery(".proj").css("opacity",0);
    		var PROJ = new Packery(document.querySelector('#work-tiles-inner'),{
      			itemSelector: '.proj',
      			gutter:1,
      			transitionDuration: "0.3s"
    		});
    		PROJ.on('layoutComplete',function(){
    			var dly = 1000;
    			jQuery(".proj").each(function(index,elem){
    				jQuery(elem).delay(dly).animate({opacity:1},750,"swing");
    				dly += 50;
    			});
      			return true;
    		});
    		PROJ.layout();

            if( jQuery("#work-tiles-inner").height() > jQuery("#work-tiles-outer").height() ){
                jQuery("#work-viewer-more").css({opacity:0}).show().animate({opacity:1},500,"swing");
                jQuery("#work-viewer-more").on("click",function(){
                    if( jQuery(this).hasClass("active") ){
                        jQuery(this).removeClass("active").html("VIEW MORE");
                        jQuery("#work-tiles-outer").animate({"min-height":"645px"},500,"swing");
                    } else {
                        var vH = parseInt(jQuery("#work-tiles-inner").height());
                        jQuery(this).addClass("active").html("VIEW LESS");
                        jQuery("#work-tiles-outer").animate({"min-height":vH + "px"},500,"swing");
                    }
                });
            }
    });

    jQuery(window).on("resize orientationchange",function(){
        var vW = parseInt(jQuery(window).width());
        if( vW < 1024 ){
            jQuery("#work-viewer-more").removeClass("active").html("VIEW MORE");
            jQuery("#work-tiles-outer").css({"min-height":"645px"});
        }
    });
</script>
