$(document).foundation();

$(document).ready(function(){

  //open the mobile menu
  $('#topnav-mobile .mobile-bars,#topnav-mobile .mobile-x').on('click',function (e) {
    $( "#topnav-mobile ul" ).slideToggle( "slow" );
    $(this).toggleClass('mobilemenu-active');
    $('#topnav-mobile .mobile-bars,#topnav-mobile .mobile-x').toggle();
  });

  //open our team bio pop-up
  $('.team-box-text').on('click',function (e) {
    var name = $(this).find('.name').html();
    var title = $(this).find('.title').html();
    var img = $(this).attr('data-img');
    var bio = $(this).attr('data-bio');
    $('.overlay-bio .name').html(name);
    $('.overlay-bio .title').html(title);
    $('.overlay-bio .thumbnail').attr("src",img);
    $('.overlay-bio .bio').html(bio);
    $('.overlay-bio,.overlay-white').fadeIn();
  });
  //close our team bio pop-up
  $('.overlay-bio .close,.overlay-white').on('click',function (e) {
    $('.overlay-bio,.overlay-white').fadeOut();
    $('.overlay-bio .name,.overlay-bio .title,.overlay-bio .bio').html('');
    $('.overlay-bio .thumbnail').attr("src","");
  });

  //insert email in footer
    $( "#email" ).html( "<a href='mailto:jnichol@handlpartners.com'>jnichol@handlpartners.com</a>" );

    $.stellar({
        horizontalScrolling: false,
        positionProperty: 'transform',
        hideDistantElements: false
    });



    $('.slider-for').slick({
      slidesToShow: 1,
      slidesToScroll: 1,
      arrows: false,
      fade: true,
      asNavFor: '.slider-nav'
    });
    $('.slider-nav').slick({
      slidesToShow: 7,
      slidesToScroll: 0,
      asNavFor: '.slider-for',
      dots: true,
      centerMode: false,
      focusOnSelect: true,
      centerPadding:0
    });
    // start and pause Videos
    $('.slider-for').on('beforeChange', function(event, slick, currentSlide, nextSlide){
        if($(slick.$slides.get(currentSlide)).hasClass('video')){
            $(slick.$slides.get(currentSlide)).children('video').get(0).pause();
            $(slick.$slides.get(currentSlide)).children('video').get(0).currentTime = 0;
        }
        if($(slick.$slides.get(currentSlide)).hasClass('radio')){
            $(slick.$slides.get(currentSlide)).children('audio').get(0).pause();
            $(slick.$slides.get(currentSlide)).children('audio').get(0).currentTime = 0;
        }
        if($(slick.$slides.get(currentSlide)).hasClass('banner')){
            $(slick.$slides.get(currentSlide)).find('iframe').attr('src','');
        }
    });
    $('.slider-for').on('afterChange', function(event, slick, currentSlide, nextSlide){
      if($(slick.$slides.get(currentSlide)).hasClass('video')){
        $(slick.$slides.get(currentSlide)).children('video').get(0).play();
      }
      if ($(slick.$slides.get(currentSlide)).hasClass('radio')){
        $(slick.$slides.get(currentSlide)).children('audio').get(0).play();
      }
      if ($(slick.$slides.get(currentSlide)).hasClass('banner')){
          var src = $(slick.$slides.get(currentSlide)).attr('data-src');
          src = '../assets/banners/'+src+'/index.html';
          $(slick.$slides.get(currentSlide)).find('iframe').attr('src',src);
      }
    });

    $(window).on('resize', function(){
        $('.slider-for .banner,.slider-for .radio').css({height:$('.slider-for .video').css('height')});
        $('.slider-nav p').css({width:$('.slider-nav img').css('width')});
    });
    $('.slider-for .banner,.slider-for .radio').css({height:$('.slider-for .video').css('height')+10});

    $('.slider-nav p').css({width:$('.slider-nav img').css('width')});

    $('.slider-for .video,.slider-for .radio').append('<div class="play-btn" style="background-image:url(http://www.handlpartners.com/lovinit/assets/images/play-button.png)"></div><div class="pause-btn" style="background-image:url(http://www.handlpartners.com/lovinit/assets/images/pause-button.png)"></div>');

    $('.play-btn').on('click',function(){
        if ($(this).parent().hasClass('video')){
            $(this).siblings('video').get(0).play();
        }
        if ($(this).parent().hasClass('radio')){
            $(this).siblings('audio').trigger('play');
        }
        $(this).fadeOut();
    });
    $('.pause-btn').on('click',function(){
        if ($(this).parent().hasClass('video')){
            $(this).siblings('video').get(0).pause();
        }
        if ($(this).parent().hasClass('radio')){
            $(this).siblings('audio').get(0).pause();
        }
        $(this).fadeOut();
        $(this).siblings('.play-btn').fadeIn();
    });
    $('.slider-for .slick-slide').on('mouseenter',function (e) {
        if ($(this).children('.play-btn').css("display") == "none"){
            $(this).children('.pause-btn').fadeIn();
        }
    });
    $('.slider-for .slick-slide').on('mouseleave',function (e) {
        $(this).children('.pause-btn').fadeOut();
    });



});
