<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>H&L Lovin' It | The Drink Run</title>
    <meta name="description" content="">
	<meta name="robots" content="noindex, nofollow" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="../assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="../assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/styles.css">
    <script type="text/javascript" src="../assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="../assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="../assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="../assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="../assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="../assets/js/app.js"></script>
    <script type="text/javascript" src="../assets/js/slick/slick.min.js"></script>
</head>
<body>

<?php include_once "../header.php"; ?>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1 class="case-study-h1">MCDONALD'S</h1>
          <h2  class="case-study-h2">Drink Run</h2>
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns drink-run1">
          <img src="../assets/images/drink-run1.jpg"/>
      </div>
    </div>
    <div class="row panel-text drink-run2">
      <div class="small-12 columns">
          <div>
              <div class="impact">
                  <div class="line"><div></div></div>THE OPPORTUNITY<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              Driving drink sales to drive cash flow
              <p>There are 8 beverage occasions a day, compared to 3 eating occasions. We have the product quality and variety, but McDonald’s had not previously promoted itself as a drink destination.</p>
          </div>
      </div>
    </div>
    <div class="row panel-slider drink-run3">
        <div class="spacer small-12 columns">&nbsp;
        </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="medium-12 large-10 columns">
              <div class="slider slider-for">
                  <div class="video">
                      <video playsinline poster="../assets/images/CaseStudyPhotos/drinkrun-thumb-airport.jpg">
                          <source src="https://player.vimeo.com/external/164310960.hd.mp4?s=66e33e003ab99a3627027daa3a70df3d0e93081f&profile_id=174" type="video/mp4">
                      </video>
                  </div>
                   <div class="image">
                      <img src="../assets/images/CaseStudyPhotos/drinkrun-OOH.jpg"/>
                   </div>
                    <div class="video">
                        <video playsinline>
                            <source src="https://player.vimeo.com/external/99074416.hd.mp4?s=c277e0131df601ed77e8fc7a3b456f989ac80d42&profile_id=113" type="video/mp4">
                        </video>
                	</div>
                    <div class="image">
                        <img src="../assets/images/CaseStudyPhotos/drinkrun-van.jpg"/>
                    </div>
                    <!--<div class="banner" data-src="DrinkRun/Blended199_300x250">
                        <div>
                            <iframe width="300px" height="250px" src=""></iframe>
                        </div>
                    </div>-->
                    <div class="video">
                        <video playsinline>
                            <source src="https://player.vimeo.com/external/164583265.hd.mp4?s=1c1855d518ca92186cea4e30c24333d431a72238&profile_id=174" type="video/mp4">
                        </video>
                    </div>
				</div>
				<div class="slider slider-nav">
                    <div><img src="../assets/images/CaseStudyPhotos/drinkrun-thumb-airport.jpg"/><p>TV</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/drinkrun-OOH.jpg"/><p>OOH</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/drinkrun-memoman.jpg"/><p>TV</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/drinkrun-thumb-van.jpg"/><p>Street Team</p></div>
                    <!--<div><img src="../assets/images/CaseStudyPhotos/drinkrun-thumb-frappe.jpg"/></div>-->
                    <div><img src="../assets/images/CaseStudyPhotos/drinkrun-boardmeeting.jpg"/><p>TV</p></div>
				</div>

          </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
    </div>
    <div class="row panel-text drink-run4 impact-red">
      <div class="small-12 columns">
          <div class="wider">
              <div class="impact impact-red">
                  <div class="line"><div></div></div>IMPACT<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              <p>As blended ice McCafe drinks increased <span id="threehundred">300</span>% in year one of the campaign, The Drink Run has become the summertime anthem in 18 markets across the US system.</p>
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
      </div>
    </div>
</div>

<?php include_once "../footer.php"; ?>
<script>

var controller = new ScrollMagic.Controller();

    var tl = new TimelineLite({paused:true});
    tl.to($('.drink-run2 .line div'), 2, {width:'100%'});
    tl.to($('.drink-run2 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run2",duration:200})
        .addTo(controller)
        .setTween(tl.play());

    var tl2 = new TimelineLite({paused:true});
    tl2.to($('.drink-run4 .line div'), 2, {width:'100%'});
    tl2.to($('.drink-run4 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run4",duration:200})
        .addTo(controller)
        .setTween(tl2.play());

    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run4"})
        .on('start', function () {
            $('#threehundred').prop('number', 200).animateNumber({ number: 300 },1000);
        })
        .reverse(false)
        .addTo(controller);


    var scene7 = new ScrollMagic.Scene({triggerElement: ".slider-for"})
        .on('start', function () {
            function isTouchDevice() {
                return 'ontouchstart' in document.documentElement;
            }
            if (isTouchDevice()) {
                $('.slider-for .slick-current').find('.play-btn').fadeIn();
            } else {
                $('.slider-for .slick-current').children('video').get(0).play();
            }
        })
        .reverse(false)
        .addTo(controller);

</script>
</body>
</html>
