<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>H&L Lovin' It | Lobster Roll</title>
    <meta name="description" content="">
	<meta name="robots" content="noindex, nofollow" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="../assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="../assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/styles.css">
    <script type="text/javascript" src="../assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="../assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="../assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="../assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="../assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="../assets/js/app.js"></script>
    <script type="text/javascript" src="../assets/js/slick/slick.min.js"></script>
</head>
<body>

<?php include_once "../header.php"; ?>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1 class="case-study-h1">MCDONALD'S</h1>
          <h2  class="case-study-h2">Lobster Roll</h2>
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns drink-run1">
          <img src="../assets/images/case-study6.jpg"/>
      </div>
    </div>
    <div class="row panel-text drink-run2">
      <div class="small-12 columns">
          <div>
              <div class="impact">
                  <div class="line"><div></div></div>THE OPPORTUNITY<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              We developed a fully integrated campaign for Lobster Roll, ranging from TV and out-of-home, down to restaurant activation elements.
              <p>Lobster Rolls are a regional favorite in New England, particularly in the summer peak when many of our IEO and deli competitors offer this LTO, at a price point between $12 and $16. At a value price we have been able to drive significant GC and gross margin increases - all while improving our food quality perceptions.
</p>
          </div>
      </div>
    </div>
    <div class="row panel-slider drink-run3">
        <div class="spacer small-12 columns">&nbsp;
        </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="medium-12 large-10 columns">
              <div class="slider slider-for">
					<div class="video">
                        <video playsinline poster="../assets/images/CaseStudyPhotos/lobsterroll-thumb-video.jpg">
                            <source src="https://player.vimeo.com/external/135476901.hd.mp4?s=bbe3939e9714ed4faf3f0df73a2ba60d1825c730&profile_id=113" type="video/mp4">
                        </video>
                	</div>
                    <div class="image">
                        <div><img src="../assets/images/CaseStudyPhotos/LobsterRoll-OOH.jpg"/></div>
                	</div>
                    <div class="radio">
                        <img src="../assets/images/CaseStudyPhotos/radio-bg.jpg"/>
                        <audio>
                              <source src="../assets/mp3/LobsterRoll-Fat-Lip.mp3" type="audio/mpeg">
                              <source src="../assets/mp3/LobsterRoll-Fat-Lip.wav" type="audio/wav">
                              <source src="../assets/mp3/LobsterRoll-Fat-Lip.ogg" type="audio/ogg">
                        </audio>
                    </div>
                    <div class="image">
                        <div><img src="../assets/images/CaseStudyPhotos/LobsterRoll-Poster.jpg"/></div>
                    </div>
                    <div class="video">
                        <video playsinline>
                            <source src="https://player.vimeo.com/external/211750636.hd.mp4?s=4546cef2b8a3d4c44aae50dbefd9d2f40058c5ab&profile_id=174" type="video/mp4">
                        </video>
                    </div>
				</div>
				<div class="slider slider-nav">
                    <div><img src="../assets/images/CaseStudyPhotos/lobsterroll-thumb-video.jpg"/><p>TV</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/LobsterRoll-OOH.jpg"/><p>OOH</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/radio-bg.jpg"/><p>Radio</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/LobsterRoll-Poster.jpg"/><p>Merchandising</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/lobsterroll-thumb-video2.jpg"/><p>Menu Board</p></div>
				</div>

          </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
    </div>
    <div class="row panel-text drink-run4 impact-red">
      <div class="small-12 columns">
          <div class="wider">
              <div class="impact impact-red">
                  <div class="line"><div></div></div>IMPACT<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              <p>Over the last two summers, Boston Region operators added $<span id="number1">14</span>.2 million in Lobster Roll sales (excluding add-ons), generating over $<span id="number2">5</span> million in gross margin - all while attracting a higher end consumer segment to our restaurants.</p>
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
      </div>
    </div>
</div>

<?php include_once "../footer.php"; ?>
<script>

var controller = new ScrollMagic.Controller();

    var tl = new TimelineLite({paused:true});
    tl.to($('.drink-run2 .line div'), 2, {width:'100%'});
    tl.to($('.drink-run2 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run2",duration:200})
        .addTo(controller)
        .setTween(tl.play());

    var tl2 = new TimelineLite({paused:true});
    tl2.to($('.drink-run4 .line div'), 2, {width:'100%'});
    tl2.to($('.drink-run4 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run4",duration:200})
        .addTo(controller)
        .setTween(tl2.play());

    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run4"})
        .on('start', function () {
            $('#number1').prop('number', 10).animateNumber({ number: 14 },300);
            $('#number2').prop('number', 0).animateNumber({ number: 5 },300);
        })
        .reverse(false)
        .addTo(controller);

    var scene7 = new ScrollMagic.Scene({triggerElement: ".slider-for"})
        .on('start', function () {
            function isTouchDevice() {
                return 'ontouchstart' in document.documentElement;
            }
            if (isTouchDevice()) {
                $('.slider-for .slick-current').find('.play-btn').fadeIn();
            } else {
                $('.slider-for .slick-current').children('video').get(0).play();
            }
        })
        .reverse(false)
        .addTo(controller);

</script>
</body>
</html>
