<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>H&L Lovin' It | Multicultural</title>
    <meta name="description" content="">
	<meta name="robots" content="noindex, nofollow" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="assets/css/styles.css">
    <script type="text/javascript" src="assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="assets/js/slick/slick.min.js"></script>
    <script type="text/javascript" src="assets/js/app.js"></script>
</head>
<body>

<?php include_once "header.php"; ?>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1>H&L PARTNERS</h1>
          <h2>Multicultural Marketing</h2>
      </div>
    </div>
    <section id="panel-video">
        <video autoplay loop muted playsinline poster="assets/images/multicultural-video-poster.jpg">
         <source src="https://player.vimeo.com/external/212120526.hd.mp4?s=60cadaa849e4352e5de3733395383fd9871b73d9&profile_id=174" type="video/mp4">
       </video>
       <div id="homepage-video-headlines">
           <div class="homepage-video-headline headline1">
               <h1>Effective multicultural marketing goes far beyond delivering relevant advertising messaging.</h1>
           </div>
           <div class="homepage-video-headline headline2">
               <h1>Understanding cultural insights leads to identifying unique opportunities.</h1>
           </div>
       </div>
   </section>
    <div class="row panel-text pr-3">
      <div class="small-12 columns">
          <div>
              <div class="impact">
                  <div class="line"><div></div></div>OUR TEAM<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              Seasoned marketing professionals providing leadership across diverse local markets.
          </div>
      </div>
      <div class="spacer small-12 columns">&nbsp;
      </div>
    </div>

    <section id="team-boxes">
      <div class="row">
<div class="team-box small-12 medium-6 large-4 columns" style="display:none">
            <div class="hover-left team-box-photo" style="background-image:url(assets/images/team24.jpg)">
            </div>
            <div class="team-box-text" data-img="assets/images/team24.jpg" data-bio="Mike is a 20+ year veteran of the agency business with over 17 years leading McDonald’s co-ops from Key West to the Carolinas. As a Miami native, Mike has developed a deep understanding of the multicultural consumer and how to connect with them. He is passionate about understanding his clients’ business and getting to know the challenges they face in order to grow operator cash flow.">
              <table>
                  <tr>
                      <td>
                          <p class="name">Mike Castillo</p>
                          <p class="title">VP/Managing Director</p>
                      </td>
                  </tr>
              </table>
          </div>
          <div class="team-box-white"></div>
        </div>

         <div class="team-box small-12 medium-6 large-4 columns">
          <div class="hover-right team-box-photo" style="background-image:url(assets/images/team21.jpg)">
          </div>
          <div class="team-box-text" data-img="assets/images/team21.jpg" data-bio="Mark started Mosaic Multicultural in 2013 after spending over 10 years working at various agencies from coast to coast. His vision is to create a better approach to multicultural marketing. Mark has spent his career driving strategy/planning and has led multiple McDonald’s co-ops for the past 10 years in the Houston, Pacific Sierra, and Rocky Mountain regions.">
            <table>
                <tr>
                    <td>
                        <p class="name">Mark Suarez</p>
                        <p class="title">Managing Director</p>
                    </td>
                </tr>
            </table>
        </div>
        <div class="team-box-white"></div>
      </div>
 <div class="team-box small-12 medium-6 large-4 columns">
              <div class="hover-left team-box-photo" style="background-image:url(assets/images/team5.jpg)">
              </div>
              <div class="team-box-text" data-img="assets/images/team5.jpg" data-bio="A consumer insight apasionada, Maribel brings authentic insights into our invaluable Hispanic consumer strategy for McDonald’s, and contributes to the overall coordination of all multicultural marketing programs.  Born and raised in Mexico City, Maribel has over 20 years of experience in advertising, initially at Grey/Mexico handling Procter & Gamble brands and later at BBDO, where she led the Bayer and Frito-Lay accounts.">
                <table>
                    <tr>
                        <td>
                            <p class="name">Maribel Orozco</p>
                            <p class="title">VP/Director of Multicultural Marketing</p>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="team-box-white"></div>
          </div>


          <div class="team-box small-12 medium-6 large-4 columns">
              <div class="hover-top team-box-photo" style="background-image:url(assets/images/team14.jpg)">
              </div>
              <div class="team-box-text" data-img="assets/images/team14.jpg" data-bio="Heather brings more than a decade of public relations experience to H&L Partners, having previously represented leading brands that include Target, General Mills, and AT&T. At H&L, Heather leads the PR team and drives the McDonald’s PR strategy that supports advertising, product launches and promotions, and local store marketing. In addition to general market PR engagement, she’s also passionate about helping clients reach African American consumers and has been doing so for much of her career. This passion lends itself well to the work she does with the McDonald’s St. Louis leadership to help the co-op reach African American consumers through meaningful and relevant initiatives.">
                <table>
                    <tr>
                        <td>
                            <p class="name">Heather Woodard</p>
                            <p class="title">Director of Public Relations and Social Media</p>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="team-box-white"></div>
          </div>
          <div class="team-box small-12 medium-6 large-4 columns">
              <div class="hover-top team-box-photo" style="background-image:url(assets/images/team9c.jpg)">
              </div>
              <div class="team-box-text" data-img="assets/images/team9c.jpg" data-bio="Thuy joined H&L Partners four years ago to work in account management and contribute to multicultural efforts targeting Asian American consumers. She joined the agency from Interpublic Worldwide, and has executed integrated marketing plans for McDonald’s, reaching multi-ethnic communities through traditional advertising channels as well as grassroots outreach.">
                <table>
                    <tr>
                        <td>
                            <p class="name">Thuy Cao</p>
                            <p class="title">Account Director</p>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="team-box-white"></div>
          </div>

          <div class="team-box small-12 medium-6 large-4 columns">
              <div class="hover-top team-box-photo" style="background-image:url(assets/images/team16.jpg)">
              </div>
              <div class="team-box-text" data-img="assets/images/team16.jpg" data-bio="Camille León began her McDonald’s career five years ago in the New York Metro Region, where she was specifically responsible for all the Hispanic Consumer Marketing and Advertising. After two years in New York, she moved to Boston to join H&L. Camille helps in different areas of the McDonald's business, such as co-op management and business and production development. She leads the Multicultural segment in the Boston Region and is responsible for the overall management and tracking of the regional budget.">
                <table>
                    <tr>
                        <td>
                            <p class="name">Camille León</p>
                            <p class="title">Account Director</p>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="team-box-white"></div>
          </div>
        <div class="team-box small-12 medium-6 large-4 columns">
            <div class="hover-left team-box-photo" style="background-image:url(assets/images/team17.jpg)">
            </div>
            <div class="team-box-text" data-img="assets/images/team17.jpg" data-bio="Stephanie comes to the H&L team with seven years of combined agency and corporate McDonald's experience. She worked in both the Northwest and Florida regions on the regional marketing team and led public relations efforts. Stephanie also had the opportunity to head up national African American PR programs during a field exchange role with the McDonald's USA Communications team. Stephanie holds a Bachelor's degree in Broadcast Journalism from Florida A&M University.">
              <table>
                  <tr>
                      <td>
                          <p class="name">Stephanie Mackey</p>
                          <p class="title">Sr. Account Executive / Public Relations</p>
                      </td>
                  </tr>
              </table>
          </div>
          <div class="team-box-white"></div>
        </div>

        <div class="team-box small-12 medium-6 large-4 columns">
            <div class="hover-right team-box-photo" style="background-image:url(assets/images/team19.jpg)">
            </div>
            <div class="team-box-text" data-img="assets/images/team19.jpg" data-bio="Cordell began his career with H&L as an Assistant Account Executive, where he was responsible for managing merchandising for over 600 stores for McDonald’s Boston on campaigns such as Lobster Roll and McCafé Flavor Shot. In 2016, Cordell was promoted to Account Executive on the McDonald’s Lexington account, where in addition to managing the merchandising needs of the co-op, he focuses on client service for the McDonald’s Bluegrass account.">
              <table>
                  <tr>
                      <td>
                          <p class="name">Cordell Martin</p>
                          <p class="title">Account Executive</p>
                      </td>
                  </tr>
              </table>
          </div>
          <div class="team-box-white"></div>
        </div>
<div class="team-box small-12 medium-6 large-4 columns">
          <div class="hover-right team-box-photo" style="background-image:url(assets/images/team22.jpg)">
          </div>
          <div class="team-box-text" data-img="assets/images/team22.jpg" data-bio="Katherine was recruited to join Mosaic in 2015 from Jack in the Box. Katherine has spent her entire career working in the QSR segment. She oversees all day-to- day local co-op execution, GMA, agency planning, and special co-op projects. Segment experience: Turquoise, Magenta, and Yellow">
            <table>
                <tr>
                    <td>
                        <p class="name">Katherine Cerrito</p>
                        <p class="title">Senior Account Executive</p>
                    </td>
                </tr>
            </table>
        </div>
        <div class="team-box-white"></div>
      </div>
<div class="team-box small-12 medium-4 large-4 columns" style="float:left">
            <div class="hover-right team-box-photo" style="background-image:url(assets/images/team23.jpg)">
            </div>
            <div class="team-box-text" data-img="assets/images/team23.jpg" data-bio="Jahred Williams joins H&amp;L Partners with 10+ years of experience in the advertising industry, all directly focused on McDonald’s local and national business. From 2008-2011, he worked as an Account Supervisor for Moroch on the Houston coop where he led all AACM initiatives. He then transitioned to Chicago where he worked as an Account Supervisor for The Marketing Store; McDonald’s national agency of record for promotions and sweepstakes. From 2012-2015, he worked as an Account Supervisor – where he oversaw all seven test markets for the McDonald’s App.">
              <table>
                  <tr>
                      <td>
                          <p class="name">Jahred Williams</p>
                          <p class="title">Account Director</p>
                      </td>
                  </tr>
              </table>
          </div>
          <div class="team-box-white"></div>
        </div>

      </div>
    </section>

    <div class="row panel-slider">
        <div class="spacer small-12 columns">&nbsp;
        </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="medium-12 large-10 columns">
              <div class="slider slider-for">
                  <div class="video" id="firstvideo">
                      <video playsinline poster="assets/images/multicultural-video-poster2.jpg">
                          <source src="https://player.vimeo.com/external/106199972.hd.mp4?s=d4eebe6d41c84f43aadb965ab6e405a9d657eb11&profile_id=113" type="video/mp4">
                      </video>
                  </div>
                  <div class="image">
                      <img src="assets/images/MulticulturalCoffeeOOH.jpg"/>
                  </div>
                  <div class="video" id="secondvideo">
                      <video playsinline style="height:100%">
                          <source src="https://player.vimeo.com/external/144826670.hd.mp4?s=2380c9a3b1f69daccb73a8c812965bda76bc254b&profile_id=113" type="video/mp4">
                      </video>
                  </div>
                    <div class="image">
                        <img src="assets/images/MulticulturalCoffeeTransit.jpg"/>
                    </div>
                    <div class="video">
                        <video playsinline>
                            <source src="https://player.vimeo.com/external/76560558.hd.mp4?s=02f95b21c331ca4e94d873907cb32f9ddd1e1ffa&profile_id=113" type="video/mp4">
                        </video>
                    </div>
				</div>
				<div class="slider slider-nav">
                    <div><img src="assets/images/multicultural-video-poster2.jpg"/><p>TV</p></div>
                    <div><img src="assets/images/MulticulturalCoffeeOOH.jpg"/><p>OOH</p></div>
                    <div><img src="assets/images/multicultural-thumb-video1.jpg"/><p>TV</p></div>
                    <div><img src="assets/images/MulticulturalCoffeeTransit.jpg"/><p>Transit</p></div>
                    <div><img src="assets/images/multicultural-thumb-video2.jpg"/><p>TV</p></div>
				</div>
          </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns" style="background-color:#ff4d37">&nbsp;
          </div>
    </div>

    <section>
        <div class="overlay-white"></div>
        <div class="row overlay-bio">
          <img class="close" src="assets/images/close.png"/>
          <div class="small-12 columns">
              <div class="name-title">
                  <img class="thumbnail" src=""/>
                  <div><span class="name"></span>, <span class="title"></span></div>
              </div>
          </div>
          <div class="small-12 columns">
              <p class="bio"></p>
          </div>
        </div>
    </section>
</div>

<?php include_once "footer.php"; ?>
<script>
$(window).on('resize', function(){
    $('#secondvideo').css({height:$('#firstvideo').css('height')});
});
$('#secondvideo').css({height:$('#firstvideo').css('height')});

var controller = new ScrollMagic.Controller();

    var tl = new TimelineLite({paused:true});
    tl.to($(' .line div'), 2, {width:'100%'});
    tl.to($(' .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".pr-3",duration:200})
        .addTo(controller)
        .setTween(tl.play());


    //var tl2 = new TimelineMax({paused:false,repeat:-1,repeatDelay:0});
    var tl2 = new TimelineLite({onComplete:function() {
        this.restart()}
    });
    tl2.to($('.headline1'), .5, {opacity:1,left:'9%'},"+=0");
    tl2.to($('.headline1'), .5, {opacity:0,left:'20%'},"+=7");
    tl2.to($('.headline2'), .5, {opacity:1,left:'9%'},"+=0");
    tl2.to($('.headline2'), .5, {opacity:0,left:'20%'},"+=6.5");
    tl2.to($('.headline2'), 3.5, {opacity:0,left:'20%'});

    var scene7 = new ScrollMagic.Scene({triggerElement: ".slider-for"})
        .on('start', function () {
            function isTouchDevice() {
                return 'ontouchstart' in document.documentElement;
            }
            if (isTouchDevice()) {
                $('.slider-for .slick-current').find('.play-btn').fadeIn();
            } else {
                $('.slider-for .slick-current').children('video').get(0).play();
            }
        })
        .reverse(false)
        .addTo(controller);
</script>
</body>
</html>
