<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>H&L Lovin' It | PR</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="assets/css/styles.css">
    <script type="text/javascript" src="assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="assets/js/slick/slick.min.js"></script>
    <script type="text/javascript" src="assets/js/app.js"></script>
<style>
.spacer {height:50px}
</style>
</head>
<body>

<?php include_once "header.php"; ?>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1>H&L PARTNERS</h1>
          <h2>Public Relations</h2>
      </div>
    </div>
    <div class="row panel-text" style="display:none">
      <div class="small-12 columns">
          <div class='wider'>
              We bring brand McDonald’s to life in local markets, where the community involvement of co-ops at the grassroots level builds brand preference.
          </div>
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns">
          <img src="assets/images/pr-hero-image.jpg"/>
      </div>
    </div>
    <div class="row panel-text pr-3">
      <div class="small-12 columns">
          <div>
              <div class="impact">
                  <div class="line"><div></div></div>OUR TEAM<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              Going beyond traditional public relations, our team manages social media outreach, event marketing, and crew incentive programs.
          </div>
      </div>
      <div class="spacer small-12 columns">&nbsp;
      </div>
    </div>

    <section id="team-boxes">
      <div class="row">
        <div class="team-box small-12 medium-6 large-3 columns">
            <div class="hover-top team-box-photo" style="background-image:url(assets/images/team14.jpg)">
            </div>
            <div class="team-box-text" data-img="assets/images/team14.jpg" data-bio="Heather brings more than a decade of public relations experience to H&L Partners, having previously represented leading brands that include Target, General Mills, and AT&T. At H&L, Heather leads the PR team and drives the McDonald’s PR strategy that supports advertising, product launches and promotions, and local store marketing. In addition to general market PR engagement, she’s also passionate about helping clients reach African American consumers and has been doing so for much of her career. This passion lends itself well to the work she does with the McDonald’s St. Louis leadership to help the co-op reach African American consumers through meaningful and relevant initiatives.">
              <table>
                  <tr>
                      <td>
                          <p class="name">Heather Woodard</p>
                          <p class="title">Director of Public Relations and Social Media</p>
                      </td>
                  </tr>
              </table>
          </div>
          <div class="team-box-white"></div>
        </div>
        <div class="team-box small-12 medium-6 large-3 columns">
            <div class="hover-top team-box-photo" style="background-image:url(assets/images/team17.jpg)">
            </div>
            <div class="team-box-text" data-img="assets/images/team17.jpg" data-bio="Stephanie comes to the H&L team with seven years of combined agency and corporate McDonald's experience. She worked in both the Northwest and Florida regions on the regional marketing team and led public relations efforts. Stephanie also had the opportunity to head up national African American PR programs during a field exchange role with the McDonald's USA Communications team. Stephanie holds a Bachelor's degree in Broadcast Journalism from Florida A&M University.">
              <table>
                  <tr>
                      <td>
                          <p class="name">Stephanie Mackey</p>
                          <p class="title">Sr. Account Executive / Public Relations</p>
                      </td>
                  </tr>
              </table>
          </div>
          <div class="team-box-white"></div>
        </div>
        <div class="team-box small-12 medium-6 large-3 columns">
            <div class="hover-right team-box-photo" style="background-image:url(assets/images/team18.jpg)">
            </div>
            <div class="team-box-text" data-img="assets/images/team18.jpg" data-bio="Jessica joined H&L Partners from online retailer eCampus.com, where she worked as the Marketing Coordinator.  At H&L, Jessica implements the PR strategy for the McDonald's Bluegrass co-op, where she manages all the social media accounts for the restaurants and supports product launches, promotions, local store marketing, and market activation. Jessica received her Bachelor's degree in Art History and Business from Transylvania University, in Lexington, Kentucky.">
              <table>
                  <tr>
                      <td>
                          <p class="name">Jessica Oles</p>
                          <p class="title">Account Executive / Public Relations</p>
                      </td>
                  </tr>
              </table>
          </div>
          <div class="team-box-white"></div>
        </div>
        <div class="team-box small-12 medium-6 large-3 columns">
            <div class="hover-top team-box-photo" style="background-image:url(assets/images/team15.jpg)">
            </div>
            <div class="team-box-text" data-img="assets/images/team15.jpg" data-bio="In her three years with H&L Partners, Chelsea has played an integral role in technology, retail marketing, and client service for the McDonald’s St. Louis account. She has helped develop and launch campaigns that continue to increase market share and gain national attention. She was also part of a small team that pioneered the digital space for McDonald’s, which led to a program that has rolled out system-wide. Prior to her time at H&L Partners, she worked for Momentum Worldwide, a global marketing agency.">
              <table>
                  <tr>
                      <td>
                          <p class="name">Chelsea Dickson</p>
                          <p class="title">Account Executive</p>
                      </td>
                  </tr>
              </table>
          </div>
          <div class="team-box-white"></div>
        </div>

      </div>
    </section>
    <div class="row panel-slider">
        <div class="spacer small-12 columns">&nbsp;
        </div>
        <div class="row panel-text drink-run2">
          <div class="small-12 columns">
              <div>
                  <h3>Academic Excellence Awards</h3>
                  <p style="padding-bottom:0">
                      Effective Public Relations reaches all ethnic segments, which is why H&L created the Academic Excellence Awards (AEA) for the AACM market in St. Louis. In partnership with the UNCF, the coop promotes academic achievement by providing college scholarship funds to African-American students. The program reaches far beyond a check presentation ceremony, and a press release.  The AEA is unique to McDonald’s, and since its inception in 2004, the coop has awarded nearly $500,000 in scholarships.
                  </p>
              </div>
          </div>
      </div>
        <div class="desktop small-0 medium-0 large-2 columns">&nbsp;
        </div>
        <div class="small-12 medium-12 large-8 columns">
            <div class="slider slider-for video1" style="margin-bottom:0;margin-top:25px">
                <div class="video">
                    <video playsinline poster="assets/images/pr-video-poster.jpg">
                        <source src="https://player.vimeo.com/external/99149401.sd.mp4?s=0c6741d0169b6cacfab58e03174bd25157f90f96&profile_id=112" type="video/mp4">
                    </video>
                </div>
            </div>
        </div>
        <div class="desktop small-0 medium-0 large-2 columns">&nbsp;
        </div>
        <div class="row panel-text drink-run2">
          <div class="small-12 columns">
              <div>
                  <p style="padding-bottom:0">
                      The communications platform promoting the AEA features television support, OOH boards and digital banners, as well as in-restaurant communications featuring our recipients on restaurant posters, trayliners and bag stuffers with a call-to-action encouraging their peers to apply.
                  </p>
              </div>
          </div>
      </div>
      <div class="row panel-3images">
           <div class="small-12 medium-5 columns">
               <img id="AEA_one" src="assets/images/pr-AEA.jpg" style="box-shadow:0 0 18px rgba(0,0,0,0.45)" width="100%"/>
           </div>
           <div class="small-12 medium-7 columns">
               <img id="AEA_two" src="assets/images/pr-AEA2.jpg" style="box-shadow:0 0 18px rgba(0,0,0,0.45)" width="100%"/>
           </div>
           <div class="spacer small-12 columns">&nbsp;
           </div>
     </div>
    <div class="row panel-slider" style="background-color:#99c9ca">
        <div class="row panel-text drink-run2">
            <div class="spacer small-12 columns">&nbsp;
            </div>
          <div class="small-12 columns">
              <div>
                  <h3 style="margin-bottom:10px">Drink Runner</h3>
                  <p style="color:#000;padding-bottom:0">Our efforts to 'Own the Drink Run' extended well beyond a creative campaign with the start-to-finish development of the Drink Runner - an unmistakable and vibrant sampling van, fully customized to meet consumers on-the-go, providing a variety of tasty beverages from McDonald's. To date, the Drink Runner has showcased beverage variety at McDonald's in style, serving up thousands of drinks at over 250 events.</p>
              </div>
          </div>
          <div class="small-12 columns" style="padding-bottom:35px;text-align:center;min-height:173;line-height:0">
              <img src="assets/images/pr-drinkrun.png" style="width:350px"/>
          </div>
        </div>
         <div class="row panel-3images">
              <div class="small-12 medium-4 columns">
                  <img src="assets/images/pr-drinkrun1.jpg" width="100%"/>
              </div>
              <div class="small-12 medium-4 columns">
                  <img src="assets/images/pr-drinkrun2.jpg" width="100%"/>
              </div>
              <div class="small-12 medium-4 columns">
                  <img src="assets/images/pr-drinkrun3.jpg" width="100%"/>
              </div>
              <div class="spacer small-12 columns">&nbsp;
              </div>
        </div>
    </div>
    <div class="row panel-slider">
        <div class="spacer small-12 columns">&nbsp;
        </div>
        <div class="row panel-text drink-run2">
          <div class="small-12 columns">
              <div>
                  <h3>Celebrating the growth of the Big Mac family</h3>
                  <p style="padding-bottom:0">We worked closely with restaurants in St. Louis and Lexington to execute the distribution of bottles of Big Mac Special Sauce. Support included the creation of Special Sauce distribution plans for restaurants, media relations, social media engagement, influencer engagement and sampling.</p>
              </div>
          </div>
      </div>
        <div class="desktop small-0 medium-0 large-2 columns">&nbsp;
        </div>
        <div class="small-12 medium-12 large-8 columns">
            <div class="slider slider-for video2" style="margin-bottom:0;margin-top:25px">
                <div class="video">
                    <video playsinline poster="assets/images/pr-video-poster2.jpg">
                        <source src="https://player.vimeo.com/external/212312111.sd.mp4?s=c1fb360b9c30d8a2c47d673f8c356e10b07cbdb4&profile_id=165" type="video/mp4">
                    </video>
                </div>
            </div>
        </div>
        <div class="desktop small-0 medium-0 large-2 columns">&nbsp;
        </div>
        <div class="spacer small-12 columns" style="height:80px">&nbsp;
        </div>
      </div>

    <section>
        <div class="overlay-white"></div>
        <div class="row overlay-bio">
          <img class="close" src="assets/images/close.png"/>
          <div class="small-12 columns">
              <div class="name-title">
                  <img class="thumbnail" src=""/>
                  <div><span class="name"></span>, <span class="title"></span></div>
              </div>
          </div>
          <div class="small-12 columns">
              <p class="bio"></p>
          </div>
        </div>
    </section>
</div>

<?php include_once "footer.php"; ?>

<script>

$(window).load(function() {
    if ($(window).width() > 640){
        $(window).on('resize', function(){
            $('#AEA_one').css({height:$('#AEA_two').css('height'),width:'auto'});
        });
        $('#AEA_one').css({height:$('#AEA_two').css('height'),width:'auto'});
    } 
});


var controller = new ScrollMagic.Controller();

    var tl = new TimelineLite({paused:true});
    tl.to($(' .line div'), 2, {width:'100%'});
    tl.to($(' .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".pr-3",duration:200})
        .addTo(controller)
        .setTween(tl.play());

    var scene7 = new ScrollMagic.Scene({triggerElement: ".video1"})
        .on('start', function () {
            function isTouchDevice() {
                return 'ontouchstart' in document.documentElement;
            }
            if (isTouchDevice()) {
                $('.video1 .slick-current').find('.play-btn').fadeIn();
            } else {
                $('.video1 .slick-current').children('video').get(0).play();
            }
        })
        .reverse(false)
        .addTo(controller);

    var scene8 = new ScrollMagic.Scene({triggerElement: ".video2"})
        .on('start', function () {
            function isTouchDevice() {
                return 'ontouchstart' in document.documentElement;
            }
            $('.video1 .slick-current').children('video').get(0).pause();

            if (isTouchDevice()) {
                $('.video2 .slick-current').find('.play-btn').fadeIn();
            } else {
                $('.video2 .slick-current').children('video').get(0).play();
            }
        })
        .reverse(false)
        .addTo(controller);

</script>
</body>
</html>
