<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Agency extends CI_Controller 
{
	//===========================================================
	// Agency Constructor
	//===========================================================

	public function __construct()
    {
    		parent::__construct();
		$this->load->library("Apps");
    }

	//===========================================================
	// Public Methods
	//===========================================================

	public function index()
	{
		$data['title'] = 'Home';

		$this->load->view('shared/header',$data);
		$this->load->view('home',$data);
		$this->load->view('shared/footer',$data);
	}
	
	public function background()
	{
		$data['title'] = 'Agency Background';

		$this->load->view('shared/header',$data);
		$this->load->view('agency-background',$data);
		$this->load->view('shared/footer',$data);
	}
	
	public function casestudies($proj="main")
	{
		$data['title'] = 'Case Studies';
		$data['banner'] = $proj.".jpg";
		$data['subpage'] = $this->load->view('creative/'.$proj,$data,TRUE);

		$this->load->view('shared/header',$data);
		if($proj == "main") $this->load->view('agency-creative-main',$data);
		else $this->load->view('agency-creative',$data);
		$this->load->view('shared/footer',$data);
	}
	
	public function ourapproach()
	{
		$data['title'] = 'Our Approach';

		$this->load->view('shared/header',$data);
		$this->load->view('our-approach',$data);
		$this->load->view('shared/footer',$data);
	}
}