<?php
/**
 * Plugin Name: H&L Pardot KeyGen
 * Description: Create automatic login keys for white paper access
 * Version: 1.0.0
 * Author: H&L Partners (Matt Johnson)
 */

//================================================
// Plugin Menus
//================================================

function hlp_keygen_menus(){
	add_menu_page('H&L KeyGen', 'H&L KeyGen', 'hl-foo', 'hl-keygen');
	add_submenu_page('hl-keygen', 'Create Key', 'Create Key', 'manage_options', 'hl-keygen-create', 'hlp_keygen_create');
}
add_action('admin_menu','hlp_keygen_menus');

function hlp_keygen_create(){
	$papers = hlp_get_papers();

	$key = "";
	$selected = "";
	$region = "";
	$errors = array();

	if( isset($_POST["submit"]) ){
		$selected = $_POST["whitepaper"];
		$region = $_POST["region"];

		if( empty($selected) ) $errors[] = "Please select a white paper";
		if( empty($region) ) $errors[] = "Please select a region";

		if( empty($errors) ){
			$path = "{$selected}/{$region}";
			$key = "http://www.handlpartners.com/what-we-do/viewpoint-access/" . base64_encode($path);
		}
	}

	include_once(__DIR__ . "/views/keygen.php");
}

function hlp_get_papers(){
	$papers = array();
	$query = new WP_Query(array(
		'post_type'       => 'hlp-whitepaper',
		'post_status'     => 'publish',
		'orderby'         => 'name',
		'order'           => 'DESC',
		'posts_per_page'  => -1,
	));

	if( $query->have_posts() ){
		while( $query->have_posts() ){
			$query->the_post();

			$paper 				= (object) array();
			$paper->id 			= get_the_ID();
			$paper->url 		= get_the_permalink();
			$paper->title 		= get_the_title();

			$papers[] = $paper;
		}
	}

	wp_reset_query();
	return $papers;
}