<?php
hlp_load_functions("models");

//======================================================================
// Case Studies Embed
//======================================================================

function case_studies_func($atts){
    $a = shortcode_atts( array(
        'mode' => 'franchise-retail',
        'posts' => -1
    ), $atts );

    ob_start();
    hlp_case_studies($a["mode"],$a["posts"]);
    return ob_get_clean();
}
add_shortcode('case-studies','case_studies_func');

//======================================================================
// Greenhorn Registration Form Embed
//======================================================================

function greenhorn_registration($atts){
	$interests = ['Creative','Account Services','Operations','Media','Project Management'];
	$offices = ['San Francisco','St. Louis'];
	$errors = [];
	$insert = [];
	$thanks = FALSE;

	$gh_name = '';
	$gh_interest = '';
	$gh_website = '';
	$gh_office = '';
	$gh_describe = '';
	$gh_program = '';

	if( isset($_POST['gh-submit']) ){

		$verify = wp_verify_nonce($_REQUEST['_wpnonce'],"greenhorn-registration");
		if( empty($verify) ){

			$errors[] = "Your session has expired, please refresh the page.";

		} else {

			//Get all posted variables
			$gh_name 		= sanitize_text_field($_POST["gh-name"]);
			$gh_cover 		= sanitize_text_field($_POST["gh-cover-src"]);
			$gh_resume 		= sanitize_text_field($_POST["gh-resume-src"]);
			$gh_reference 	= sanitize_text_field($_POST["gh-reference-src"]);
			$gh_website 	= sanitize_text_field($_POST["gh-website"]);
			$gh_interest 	= sanitize_text_field($_POST["gh-interest"]);
			$gh_office 		= sanitize_text_field($_POST["gh-office"]);
			$gh_describe 	= sanitize_text_field($_POST["gh-describe"]);
			$gh_program 	= sanitize_text_field($_POST["gh-program"]);

			$insert = [
				'name' => $gh_name,
				'cover' => $gh_cover,
				'resume' => $gh_resume,
				'reference' => $gh_reference,
				'website' => $gh_website,
				'interest' => $gh_interest,
				'office' => $gh_office,
				'describe' => $gh_describe,
				'program' => $gh_program,
				'created' => time()
			];

			//Load the validation library
			include_once(TEMPLATEPATH . "/libraries/validation/vendor/autoload.php");
			$translator = new Symfony\Component\Translation\Translator('en');
			$factory = new Illuminate\Validation\Factory($translator);

			$rules = array(
				'name' => 'required',
				'cover' => 'required',
				'resume' => 'required',
				'website' => 'sometimes|url',
				'interest' => 'required',
				'office' => 'required',
				'describe' => 'required',
				'program' => 'required'
			);
			$alerts = array(
				'name.required' => 'Your name is required',
				'cover.required' => 'A cover letter is required',
				'resume.required' => 'A resume is required',
				'website.url' => 'A valid URL is needed',
				'interest.required' => 'Select a field of interest',
				'office.required' => 'Select an office',
				'describe.required' => 'Describe yourself',
				'program.required' => 'Tell us how you heard about the program'
			);
			$validator = $factory->make($insert,$rules,$alerts);

			//Run the validation tests
			if($validator->fails()){
				$errors = $validator->messages()->all();
			} else {
				global $wpdb;
				$format = ['%s','%s','%s','%s','%s','%s','%s','%s','%s','%d'];
				$result = $wpdb->insert("hlp_greenhorns",$insert,$format);

				if( empty($result) ){
					$errors[] = "Error saving registration, please try again.";
				} else {
					$thanks = TRUE;
					$_SESSION['gh-cover'] = "";
					$_SESSION['gh-resume'] = "";
					$_SESSION['gh-reference'] = "";
					unset($_SESSION['gh-cover']);
					unset($_SESSION['gh-resume']);
					unset($_SESSION['gh-reference']);
					session_commit();

					$email = [
						'title' => 'Greenhorn Registration',
						'header' => 'Greenhorn Registration',
						'message' => hlp_render_view("greenhorn/email",$insert)
					];

					$message = hlp_render_view("email/template",$email);
					hlp_send_html_email("greenhorn@handlpartners.com","Greenhorn Registration",$message);
					
				}
			}

		}
	}

	$output = "";
	$template = TEMPLATEPATH . "/includes/greenhorn/registration.php";
	if( $thanks === TRUE ) $template = TEMPLATEPATH . "/includes/greenhorn/registration-thanks.php";

	if( file_exists($template) ){
		ob_start();
		include_once($template);
		$output = ob_get_clean();
	}

	return $output;
}
add_shortcode('greenhorn_registration_form', 'greenhorn_registration');