
<div id="work-campaign-viewer" class="clearfix">
    <div id="client-banner">
        <img src="<?php echo $client->banner;?>" />
	</div>

    <div id="work-viewer-info" class="clearfix">
        <div id="work-viewer-logo" style="background-image:url(<?php echo $client->logo;?>);"></div>
        <div id="work-viewer-copy">
            <h1><?php echo $client->name;?></h1>
            <?php echo $client->description;?>
        </div>
    </div>

    <div id="work-viewer-projects" class="clearfix">
        <div id="work-viewer-inner" class="clearfix">
            <div class="row small-up-2 medium-up-4 large-up-5">
            <?php
                $active = 0;
                foreach($client->campaigns as $campaign):
                    if( count($campaign->projects) > 0 ):
                        $active++;
            ?>

                <div class="column">
                <a href="/our-work/<?php echo @$client->slug;?>/<?php echo @$campaign->slug;?>" class="proj square" style="background-image:url(<?php echo $campaign->icons->square;?>);">
            		<span class="tile-title"><b><?php echo @$client->name;?></b><br><?php echo @$campaign->title;?></span>
            		<span class="tile-corner">
            			<img src="<?php echo get_template_directory_uri(); ?>/assets/img/hl_plus_rollover_green.png">
            		</span>
                    <div class="tile-screen"></div>
            	</a>
                </div>

            <?php endif; endforeach; ?>
            </div>
        </div>
    </div>

    <?php if( $active > 5 ): ?>
        <div id="work-viewer-more">View More</div>
    <?php endif; ?>
</div>

<script>
jQuery(document).ready(function(){
    jQuery("#work-viewer-more").on("click",function(){
        if( jQuery(this).hasClass("active") ){
            jQuery(this).removeClass("active");
            jQuery("#work-viewer-projects").animate({height:"160px"},500,"swing");
        } else {
            jQuery(this).addClass("active");
            var wH = jQuery("#work-viewer-inner").height();
            jQuery("#work-viewer-projects").animate({height:wH + "px"},500,"swing");
        }
    });

    jQuery("#client-banner").animate({opacity:1},1000,"swing");

    var dly = 500;
    jQuery(".proj").each(function(index,elem){
        jQuery(elem).delay(dly).animate({opacity:1},750,"swing");
        dly += 50;
    });
});
</script>
