<?php
/**
 * Template Name: What We Do - Viewpoint Thank You
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

$auth = false;
if( isset($_SESSION["pardot-auth"]) && !empty($_SESSION["pardot-auth"]) ) $auth = true;

hlp_load_functions("models");
$slug 	= get_query_var("pardot_data");
$paper  = hlp_gozone_details($slug);
$download = "";

get_header();

$banner = types_render_field("banner-image",array("output"=>"raw"));
if(empty($banner)) $banner = "/wp-content/uploads/2016/02/header3.jpg";
?>

<div id="page-banner" style="background-image:url(<?php echo $banner;?>);"></div>

<?php
if( !empty($auth) ):
    if( !empty($paper) ){
        if( !empty( $paper->email_download ) ) $download = $paper->email_download;
        else if( !empty( $paper->download ) ) $download = $paper->download;
    }
?>

<div id="page-content" class="row gray">
    <div class="small-12 medium-3 large-3 columns">
        <h2>THANK YOU</h2>
    </div>
    <div class="small-12 medium-9 large-9 columns nopadleft">
        <?php if( !empty($download) ): ?>
            <p>Your download will begin shortly...</p>
            <script>
                jQuery(document).ready(function(){
                    window.setTimeout(function(){
                        window.location = "<?php echo @$download;?>";
                    },3000);
                });
            </script>
        <?php else: ?>
            <p>Sorry, this download could not be found.</p>
        <?php endif; ?>

		<?php if($_SESSION["region"] === "east" || $paper->contact === "east"): ?>

			<p>In the sections below you may also find interesting and relevant papers on different aspects of effective travel advertising beneficial to helping you
			with your marketing challenges. And if you would like to speak with someone live to learn more about H&amp;L Partners expertise
			in Destination Travel advertising, or just want to pick our brains, feel free to contact:</p>

			<p>Mark Schaeffer, <a href="tel:314-454-3400">314-454-3400</a> or <a href="mailto:mschaeffer@handlpartners.com">mschaeffer@handlpartners.com</a></p>

		<?php else: ?>

			<p>In the sections below you may also find interesting and relevant papers on different aspects of effective retail advertising beneficial to helping you
			with your marketing challenges. And if you would like to speak with someone live to learn more about H&amp;L Partners expertise
			in Retail/Franchise advertising, or just want to pick our brains, feel free to contact:</p>

			<p>Andrea Alfano, <a href="tel:415-434-8500">415-434-8500</a> or <a href="mailto:andreaalfano@handlpartners.com">andreaalfano@handlpartners.com</a></p>

		<?php endif; ?>	

    </div>
</div>

<?php else: ?>

<div id="page-content" class="row gray">
    <div class="small-12 medium-3 large-3 columns">
        <h2>SORRY</h2>
    </div>
    <div class="small-12 medium-9 large-9 columns nopadleft">
        <p>Thank you for your interest in downloading our white paper "<?php echo @$paper->title;?>", however to access this white paper you
        must first register.  Please <a href="/what-we-do/gozone/<?php echo @$slug;?>">click here</a> to return to the main Viewpoint page so
        you can access this content.</p>
    </div>
</div>

<?php endif; ?>

<!--
<div id="gozone-footer" class="clearfix">
    <div class="row">
        <div class="small-12 columns">
            <a href="/what-we-do/viewpoint" class="hlbtn back right">Back To Viewpoint</a>
        </div>
    </div>
</div>

<br/>

<div id="page-related-news" class="row gray">
    <div class="small-12 columns">
        <div id="news-excerpts">
        <h2>Related News</h2>
        <?php hlp_get_news_by_category("mixed",3); ?>
        </div>
    </div>
</div>
//-->

<div id="gozone-tabs" class="clearfix">
    <div id="gozone-tab-left" class="tablink <?php if($_SESSION["region"] === "west" || $paper->contact === "west") echo 'active'; ?>">
        <div class="tab">Retail/Franchise</div>
        <div class="tab-tri"></div>
    </div>
    <div id="gozone-tab-right" class="tablink <?php if($_SESSION["region"] === "east" || $paper->contact === "east") echo 'active'; ?>">
        <div class="tab-tri"></div>
        <div class="tab">Destination Travel</div>
    </div>
</div>

<?php
$activetab1 = "active";
$activecss1 = "";
$activetab2 = "";
$activecss2 = "display:none";

if($_SESSION["region"] === "east" || $paper->contact === "east"){
	$activetab1 = "";
	$activecss1 = "display:none";
	$activetab2 = "active";
	$activecss2 = "";
}
?>

<div id="gozone-contents" class="clearfix">
    <div id="gozone-contents-left" class="tabbox <?php echo $activetab1;?>" style="<?php echo $activecss1;?>">
        <?php hlp_gozone("franchise-retail"); ?>
    </div>
    <div id="gozone-contents-right" class="tabbox <?php echo $activetab2;?>" style="<?php echo $activecss2;?>">
        <?php hlp_gozone("destination-travel"); ?>
    </div>
</div>

<script>
    jQuery(document).ready(function(){
        jQuery(".tablink").on("click",function(){
            jQuery(".tablink").removeClass("active");
            jQuery(this).addClass("active");
            jQuery(".tabbox").hide();
            jQuery(".tabbox").eq(jQuery(this).index()).fadeIn("fast");
        });
    });
</script>

<!-- Google Code for whitepaper_download Conversion Page -->
<script type="text/javascript">
/* <![CDATA[ */
var google_conversion_id = 926031320;
var google_conversion_language = "en";
var google_conversion_format = "3";
var google_conversion_color = "ffffff";
var google_conversion_label = "-9NrCMCWiGYQ2LvIuQM";
var google_remarketing_only = false;
/* ]]> */
</script>
<script type="text/javascript" src="//www.googleadservices.com/pagead/conversion.js">
</script>
<noscript>
<div style="display:inline;">
<img height="1" width="1" style="border-style:none;" alt="" src="//www.googleadservices.com/pagead/conversion/926031320/?label=-9NrCMCWiGYQ2LvIuQM&amp;guid=ON&amp;script=0"/>
</div>
</noscript>

<?php get_footer();
