<?php
/**
 * Template Name: Our Work - Filter
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

//Pull data from POST
$type      = hlp_get_input("type","post");
$media     = hlp_get_input("media","post");
$client    = hlp_get_input("client","post");
$campaign  = hlp_get_input("campaign","post");

//Cascade the filter updates
if( isset($_SESSION["type"]) && $_SESSION["type"] !== $type ){
    $media = "";
    $client = "";
    $campaign = "";
}
else if( isset($_SESSION["media"]) && $_SESSION["media"] !== $media ){
    $campaign = "";
}
else if( isset($_SESSION["client"]) && $_SESSION["client"] !== $client ){
    $campaign = "";
}

//Filter Types
if( !empty($type) && empty($media) && empty($client) && empty($campaign) ){
    hlp_redirect_to("/our-work/$type/");
}
else if( !empty($type) && !empty($media) && empty($client) && empty($campaign) ){
    hlp_redirect_to("/our-work/$type/$media/");
}
else if( !empty($type) && !empty($media) && !empty($client) && empty($campaign) ){
    hlp_redirect_to("/our-work/$type/$media/$client/");
}
else if( !empty($type) && !empty($media) && !empty($client) && !empty($campaign) ){
    hlp_redirect_to("/our-work/$type/$media/$client/$campaign/");
}
else if( !empty($type) && empty($media) && !empty($client) && empty($campaign) ){
    hlp_redirect_to("/our-work/$type/$client/");
}
else if( !empty($type) && empty($media) && !empty($client) && !empty($campaign) ){
    hlp_redirect_to("/our-work/$type/$client/$campaign");
}

//Filter Media
else if( empty($type) && !empty($media) && empty($client) && empty($campaign) ){
    hlp_redirect_to("/our-work/$media/");
}
else if( empty($type) && !empty($media) && !empty($client) && empty($campaign) ){
    hlp_redirect_to("/our-work/$media/$client/");
}
else if( empty($type) && !empty($media) && !empty($client) && !empty($campaign) ){
    hlp_redirect_to("/our-work/$media/$client/$campaign/");
}

//Filter clients
else if( empty($type) && empty($media) && !empty($client) && empty($campaign) ){
    hlp_redirect_to("/our-work/$client/");
}
else if( empty($type) && empty($media) && !empty($client) && !empty($campaign) ){
    hlp_redirect_to("/our-work/$client/$campaign/");
}

//Everything else
else {
    hlp_redirect_to("/our-work/");
}
