<?php
/**
 * Template Name: Our Work
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

hlp_load_functions("models");
hlp_load_functions("work");

$mode       = get_query_var("display_mode");
$office     = get_query_var("office");
$type       = get_query_var("type");
$media      = get_query_var("media");
$client     = get_query_var("client");
$campaign   = get_query_var("campaign");
$project    = get_query_var("project");

$mediums    = hlp_get_mediums();
$workview   = "";

//============================================================
// Load Work View
//============================================================

if($mode === "home"){
    $_SESSION["type"]       = "";
    $_SESSION["media"]      = "";
    $_SESSION["client"]     = "";
    $_SESSION["campaign"]   = "";
    @session_commit();

    $workview = hlp_get_current_campaigns();
}
else if($mode === "office"){
    $_SESSION["type"]       = "";
    $_SESSION["media"]      = "";
    $_SESSION["client"]     = "";
    $_SESSION["campaign"]   = "";
    @session_commit();

    $workview = hlp_get_office_campaigns($office);
}
else if($mode === "type-redirect"){
    $parts = array($type,$media);
    if( !empty($client) ) $parts[] = $client;
    if( !empty($campaign) ) $parts[] = $campaign;
    if( !empty($project) ) $parts[] = $project;
    $path = "/our-work/" . implode("/",$parts);
    hlp_redirect_to($path);
}
else if($mode === "type-media" || $mode == "type-client"){
    /* This is really a grab-bag of possibilities */
    /* /our-work/franchise-retail/?/?/?/?/ */
    if($mode === "type-media"){
        $_SESSION["type"]       = $type;
        $_SESSION["media"]      = $media;
    } else {
        $_SESSION["type"]       = $type;
        $_SESSION["media"]      = "";
    }

    $seg1 = $client;
    $seg2 = $campaign;
    $seg3 = $project;

    /* Parse out anything and everything */
    $clients = hlp_get_clients_by_type($type);
    $campaigns = hlp_get_campaigns_list();

    if( empty($client) ){
        /* This is the easiest - just find the projects in this type */
        $_SESSION["client"]     = "";
        $_SESSION["campaign"]   = "";
        @session_commit();

        $workview = hlp_get_all_projects_by_clients($clients);
    } else {
        /* Start at the extremes and work back */
        if( !empty($seg1) && !empty($seg2) && !empty($seg3) ){
            /* Assume this is client/campaign/project */
            if( !in_array($seg1,$clients) ) hlp_redirect_to("/our-work/$type/$media/");

            $_SESSION["client"]     = $client;
            $_SESSION["campaign"]   = $campaign;
            @session_commit();

            $workview = hlp_get_all_projects_by_campaign($client,$campaign,$project);
        }
        else if( !empty($seg1) && !empty($seg2) ){
            /* This is either client/campaign or client/project */
            if( !in_array($seg1,$clients) ) hlp_redirect_to("/our-work/$type/$media/");

            if( in_array($seg2,$campaigns) ){
                /* This is a campaign */
                $_SESSION["client"]     = $client;
                $_SESSION["campaign"]   = $campaign;
                @session_commit();

                $workview = hlp_get_all_projects_by_campaign($client,$seg2);
            } else {
                /* Try for a client */
                $_SESSION["client"]     = $client;
                $_SESSION["campaign"]   = "";
                @session_commit();

                $workview = hlp_get_all_projects_by_client($client,$seg2);
            }
        }
        else {
            if( in_array($seg1,$clients) ){
                /* This is a client */
                $_SESSION["client"]     = $client;
                $_SESSION["campaign"]   = "";
                @session_commit();

                $workview = hlp_get_all_projects_by_client($client);
            } else {
                /* Try for a project */
                $_SESSION["client"]     = "";
                $_SESSION["campaign"]   = "";
                @session_commit();

                $workview = hlp_get_all_projects_by_clients($clients,$seg1);
            }
        }
    }
}
else if($mode === "type"){
    $_SESSION["type"]       = $type;
    $_SESSION["media"]      = "";
    $_SESSION["client"]     = "";
    $_SESSION["campaign"]   = "";
    @session_commit();

    $workview = hlp_get_campaigns_by_type($type);
}
else if($mode === "media"){
    $_SESSION["type"]       = "";
    $_SESSION["media"]      = $media;

    $seg1 = $client;
    $seg2 = $campaign;
    $seg3 = $project;

    /* Parse out anything and everything */
    $clients = hlp_get_clients_by_media($media);
    $campaigns = hlp_get_campaigns_list();

    if( empty($client) ){
        /* This is the easiest - just find the projects in this media type */
        $_SESSION["client"]     = "";
        $_SESSION["campaign"]   = "";
        @session_commit();

        $workview = hlp_get_all_projects_by_media($media);
    } else {
        /* Start at the extremes and work back */
        if( !empty($seg1) && !empty($seg2) && !empty($seg3) ){
            /* Assume this is client/campaign/project */
            if( !in_array($seg1,$clients) ) hlp_redirect_to("/our-work/$media/");

            $_SESSION["client"]     = $client;
            $_SESSION["campaign"]   = $campaign;
            @session_commit();

            $workview = hlp_get_all_projects_by_campaign($client,$campaign,$project);
        }
        else if( !empty($seg1) && !empty($seg2) ){
            /* This is either client/campaign or client/project */
            if( !in_array($seg1,$clients) ) hlp_redirect_to("/our-work/$media/");

            if( in_array($seg2,$campaigns) ){
                /* This is a campaign */
                $_SESSION["client"]     = $client;
                $_SESSION["campaign"]   = $campaign;
                @session_commit();

                $workview = hlp_get_all_projects_by_campaign($client,$seg2);
            } else {
                /* Try for a client */
                $_SESSION["client"]     = $client;
                $_SESSION["campaign"]   = "";
                @session_commit();

                $workview = hlp_get_all_projects_by_client($client,$seg2);
            }
        }
        else {
            if( in_array($seg1,$clients) ){
                /* This is a client */
                $_SESSION["client"]     = $client;
                $_SESSION["campaign"]   = "";
                @session_commit();

                $workview = hlp_get_all_projects_by_client($client);
            } else {
                /* Try for a project */
                $_SESSION["client"]     = "";
                $_SESSION["campaign"]   = "";
                @session_commit();

                $workview = hlp_get_all_projects_by_clients($clients,$seg1);
            }
        }
    }
}
else {
    /* Anything here is /client/campaign/project */
    $_SESSION["type"]       = "";
    $_SESSION["media"]      = "";
    $_SESSION["client"]     = $client;
    $_SESSION["campaign"]   = $campaign;
    @session_commit();

    $clients = hlp_get_clients();

    if( in_array($client,$clients) ){
        if( !empty($campaign) ){
            $workview = hlp_get_all_projects_by_campaign($client,$campaign,$project);
        } else {
            $workview = hlp_get_client_home($client);
        }
    }
}

if( empty($workview) ){
    hlp_redirect_to("/our-work/");
}

//============================================================
// Load Framework
//============================================================

get_header("work");
echo $workview;
get_footer();
