<?php

function register_styles_and_scripts() {

  // Google Fonts
  wp_register_style('googleFonts', 'https://fonts.googleapis.com/css?family=Muli:200,300,400,500,600,700');
  wp_enqueue_style( 'googleFonts');

  // CSS
  wp_enqueue_style( 'slick', get_template_directory_uri() . '/vendors/slick/slick.css');
  wp_enqueue_style( 'slick-theme', get_template_directory_uri() . '/vendors/slick/slick-theme.css');
  wp_enqueue_style( 'fnd-css', get_template_directory_uri() . '/css/app.min.css');

  // JS
  wp_enqueue_script( 'sharethis', '//platform-api.sharethis.com/js/sharethis.js#product=custom-share-buttons', null, '1.0.0', true);

  wp_deregister_script('jquery');
  wp_register_script( 'jquery', '//cdnjs.cloudflare.com/ajax/libs/jquery/2.2.4/jquery.min.js', null, '2.2.4', true);
  wp_enqueue_script( 'font-awesome', '//use.fontawesome.com/dd689c85cf.js', array( 'jquery' ), '4.7.0', true);
//  wp_enqueue_script( 'timelinemax', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/1.20.3/TweenMax.min.js', array( 'jquery' ), '', true);
  wp_enqueue_script( 'fnd-js', get_template_directory_uri() . '/js/app.min.js', array( 'jquery' ), '1.0', false);
  wp_enqueue_script( 'theme_typekit', '//use.typekit.net/nfy0ufy.js', '', true);
}
add_action('wp_enqueue_scripts', 'register_styles_and_scripts');



function theme_typekit_inline() {
  if ( wp_script_is( 'theme_typekit', 'done' ) ) { ?>
    <script>try{Typekit.load({ async: true });}catch(e){}</script>
  <?php }
}
add_action( 'wp_head', 'theme_typekit_inline' );

// // Configure custom excerpt length
// function custom_excerpt($new_length = 20, $new_more = '...') {
//   add_filter('excerpt_length', function () use ($new_length) {
//     return $new_length;
//   }, 999);
//   add_filter('excerpt_more', function () use ($new_more) {
//     return $new_more;
//   });
//   $output = get_the_excerpt();
//   $output = apply_filters('wptexturize', $output);
//   $output = apply_filters('convert_chars', $output);
//   $output = '<p>' . $output . '</p>';
//   echo $output;
// }


//Page Slug Body Class
function add_slug_body_class( $classes ) {
  global $post;
  if ( isset( $post ) ) {
    $classes[] = $post->post_type . '-' . $post->post_name;
  }
  return $classes;
}
add_filter( 'body_class', 'add_slug_body_class' );



// Featured Image Support
add_theme_support( 'post-thumbnails' );



// Options Page via ACF
if( function_exists('acf_add_options_page') ) {
    acf_add_options_page(
        array(
            'page_title' => 'Options',
            'menu_title' => 'Options',
            'menu_slug' => 'option',
        )
    );
}


/*********************
MENUS & NAVIGATION
*********************/
// REGISTER MENUS
register_nav_menus(
    array(
        'main-nav' => __( 'Main Menu'),
        'footer-nav' => __( 'Footer Menu' ),
    )
);



// CUSTOM MAIN MENU
function custom_main_nav() {
    wp_nav_menu(array(
        'container' => false,                          // remove nav container
        'container_class' => '',                       // class of container (should you choose to use it)
        'menu' => __( 'Main Menu' ),                   // nav name
        'menu_class' => '',                            // adding custom nav class
        'theme_location' => '',                        // where it's located in the theme
        'before' => '',                                // before the menu
        'after' => '',                                 // after the menu
        'link_before' => '',                           // before each link
        'link_after' => '',                            // after each link
        'fallback_cb' => ''                            // fallback function
    ));
} /* end main nav */



// CUSTOM MOBILE MENU
function custom_footer_nav() {
    wp_nav_menu(array(
        'container' => false,                           // remove nav container
        'container_class' => '',                        // class of container (should you choose to use it)
        'menu' => __( 'Footer Menu' ),                  // nav name
        'menu_class' => 'flat-list',                    // adding custom nav class
        'theme_location' => '',                         // where it's located in the theme
        'before' => '',                                 // before the menu
        'after' => '',                                  // after the menu
        'link_before' => '',                            // before each link
        'link_after' => '',                             // after each link
        'fallback_cb' => ''                             // fallback function
    ));
} /* end footer nav */



function theme_slug_filter_wp_title( $title ) {
    if ( is_404() ) {
        $title = 'Page Not Found';
    }
    // You can do other filtering here, or
    // just return $title
    return $title;
}
// Hook into wp_title filter hook
add_filter( 'wp_title', 'theme_slug_filter_wp_title', 11 );



// Custom Function
function get_industry_classes($post_id){
  $industries = get_the_terms( $post_id, 'industry' );
  $industries_array = [];
  if ( !empty( $industries ) ){
    foreach ($industries as $ind){
      $industries_array[] = "ind-" . $ind->slug;
    }
  }
  return join($industries_array," "); 
}


//============================================================
// Custom Page Routes
//============================================================

function hlp_rewrites_init(){
	//=======================================================================
	//Anytime these are updated, go to the permalinks admin page and hit SAVE
	//=======================================================================

    add_rewrite_rule('^viewpoint/([^/]*)/thank-you/?','index.php?pagename=viewpoint/thank-you&whitepaper=$matches[1]&pardot=thanks','top');
    add_rewrite_rule('^viewpoint/([^/]*)/success/?','index.php?whitepaper=$matches[1]&pardot=success','top');
    add_rewrite_rule('^viewpoint/([^/]*)/error/?','index.php?whitepaper=$matches[1]&pardot=error','top');
    add_rewrite_rule('^viewpoint/([^/]*)/?','index.php?whitepaper=$matches[1]&pardot=','top');
	add_rewrite_rule('^viewpoint/?','index.php?pagename=viewpoint&whitepaper=','top');

	//=======================================================================
	//Anytime these are updated, go to the permalinks admin page and hit SAVE
	//=======================================================================
}
add_action('init','hlp_rewrites_init');

function hlp_query_vars($query_vars){
	//Add the query vars from our rewrites
    $query_vars[] = 'whitepaper';
    $query_vars[] = 'pardot';

	return $query_vars;
}
add_filter('query_vars','hlp_query_vars');

function hlp_get_input($field='',$mode='post',$default=''){
	$var = $default;
	if($mode === 'post'){
		if( isset($_POST[$field]) ){
			$var = $_POST[$field];
			if(is_string($var) && !is_array($var)){
				$var = trim($var);
				$var = hlp_filter_xss($var);
			}
		}
	} else {
		if( isset($_GET[$field]) ){
			$var = $_GET[$field];
			if(is_string($var) && !is_array($var)){
				$var = trim($var);
				$var = hlp_filter_xss($var);
			}
		}
	}
	return stripslashes_deep($var);
}

function hlp_filter_xss($input=''){
	$filtered = "";
	if(is_string($input) && !is_array($input)){
		$allowed_html = array(
			"a" 		=> array("href" => array(),"title" => array(), "target" => array()),
			"b" 		=> array(),
			"strong" 	=> array(),
			"em" 		=> array(),
			"i" 		=> array(),
			"strike" 	=> array(),
			"ol" 		=> array(),
			"ul" 		=> array(),
			"li" 		=> array(),
			"p" 		=> array(),
			"br" 		=> array()
		);
		$filtered = wp_kses($input,$allowed_html);
	}
	return $filtered;
}