<?php get_header(); ?>

<?php if (get_field('header')): ?>
<div class="page-hero-block about-hero">
    <div class="row collapse">
        <div class="page-hero-inner" style="max-width:1000px">
            <h1 class="page-hero <!--fade-in-->"><?php the_field('header'); ?></h1>
        </div>
    </div>
</div>
<?php endif; ?>

<?php 
$about = get_field('about');
if ($about): 
?>

<div class="about-video-section">
    <div class="row">
        <div class="large-12 columns text-center">
            <?php if ($about['title']): ?>
            <h3><?php echo $about['title']; ?></h3>
            <?php endif; ?>
            <?php if ($about['body']): ?>
            <?php echo $about['body']; ?>
            <?php endif; ?>
        </div>
    </div>

    <div class="video-block-container">
        <div class="row align-justify">
            <?php foreach ($about['blocks'] as $i => $block): ?>
            <div class="small-12 medium-6 columns video-block-column">
                <div class="video-block" data-aos="fade-up" data-aos-duration="0">
                    <div class="video-section">
                        <?php if ($block['video_id']): ?>
                        <a data-open="video-modal-<?php echo $i; ?>">
                        <div id="video-play-button-1" class="video-icon-wrapper with-modal">
                            <div class="video-icon-container"><div class="play-icon"></div></div>
                        </div>
                        </a>
                        <?php endif; ?>
                        <?php echo wp_get_attachment_image($block['poster_image']['id'], array(530,310), '', array( "class" => "poster-image" )); ?>
                    </div>
                    <div class="text-section text-center">
                        <?php if ($block['title']): ?>
                        <h4><?php echo $block['title']; ?></h4>
                        <?php endif; ?>
                        <?php if ($block['body']): ?>
                        <?php echo $block['body']; ?>
                        <?php endif; ?>
                        <?php if ($block['cta']): ?>
                        <a class="btn btn-about-video" href="<?php echo $block['cta']['url']; ?>"><?php echo $block['cta']['title']; ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php if ($block['video_id']): ?>
            <!-- Modal -->
            <div class="large reveal video-modal" id="video-modal-<?php echo $i; ?>" data-reveal>
                <div class="video-modal-iframe-container">
                    <div class="fve-video-wrapper fve-image-embed fve-thumbnail-image vimeo" style="padding-bottom:56.25%;">
                        <iframe src="//player.vimeo.com/video/<?php echo $block['video_id']; ?>?portrait=0&byline=0&title=0" width="100%" height="100%" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
                    </div>
                    <?php // echo do_shortcode("[fve]https://player.vimeo.com/video/{$block['video_id']}[/fve]");?>
                </div>
                <button class="close-button" data-close aria-label="Close modal" type="button">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php endif; ?>

            <?php endforeach; ?>
        </div>
    </div>
</div>

<?php endif; ?>

<?php 
$capabilities = get_field('capabilities');
if ($capabilities): 
?>

<div class="row capabilities-section collapse">
    <div class="large-12 columns">
        <div class="cap-heading text-center">
            <?php if ($capabilities['title']): ?>
            <h3><?php echo $capabilities['title']; ?></h3>
            <?php endif; ?>
            <?php if ($capabilities['body']): ?>
            <?php echo $capabilities['body']; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

    <?php if ($capabilities['tabs']): ?>

    <div class="row about-tab-section">
        <div class="large-12 columns">
            <ul class="tabs row collapse show-for-medium" data-tabs id="example-tabs">
                <?php foreach ($capabilities['tabs'] as $i => $tab): ?>
                <li class="tabs-title column <?php if ($i == 0) { echo " is-active"; } ?>">
                    <a href="#panel<?php echo $i; ?>" aria-selected="true">
                        <?php echo wp_get_attachment_image($tab['icon']['id'], array(50,50), '', array( "class" => "tab-icon" )); ?>
                        <?php echo $tab['title']; ?>
                    </a>
                </li>
                <?php endforeach; ?>
            </ul>

            <div class="tabs-content" data-tabs-content="example-tabs">
            <?php foreach ($capabilities['tabs'] as $i => $tab): ?>
                <div class="tabs-panel <?php if ($i == 0) { echo " is-active"; } ?>" id="panel<?php echo $i; ?>">
                    <div class="show-for-small-only text-center">
                        <a href="#panel<?php echo $i; ?>" aria-selected="true">
                            <?php echo wp_get_attachment_image($tab['icon']['id'], array(50,50), '', array( "class" => "tab-icon" )); ?>
                            <?php echo $tab['title']; ?>
                        </a>
                    </div>
                    <div class="row">
                        <div class="large-12 columns overview" style="max-width:100%;width:100%;flex:100%">
                            <div class="row text-columns">
                                <div class="small-12 medium-7 columns overview-column">
                                    <p class="heading"><?php echo $tab['title']; ?> Overview</p>
                                    <?php echo $tab['overview']; ?>
                                </div>
                                <div class="small-12 medium-5 columns services-column">
                                    <p class="heading"><?php echo $tab['title']; ?> Services</p>
                                    <?php echo $tab['services']; ?>
                                </div>
                            </div>
                        </div>

                        <div class="large-4 columns featured" style="display:none">
                            <p class="heading">Featured Project</p>
                            <?php
                                $post = $tab['featured_project'][0];
                                setup_postdata($post);
                                $featured_image_id = get_post_thumbnail_id($post->ID);
                            ?>
                            <a href="<?php the_permalink(); ?>">
                                <?php echo wp_get_attachment_image($featured_image_id, array(227,130), '', array( "class" => "featured-poster-image" )); ?>
                                <p class="subtitle"><?php the_title(); ?></p>
                                <p><?php echo wp_trim_words(get_field('subheading'), 10, '...'); ?></p>
                            </a>
                            <?php wp_reset_postdata(); ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            </div>
        </div>
    </div>

    <?php endif; ?>

<?php endif; ?>

<?php 
$leadership = get_field('leadership');
if ($leadership): 

$leaders = array_filter($leadership['personnel'], function($person){
    return $person['partner'] === "yes";
});

$staff = array_filter($leadership['personnel'], function($person){
    return $person['partner'] !== "yes";
});

shuffle($leaders);
shuffle($staff);

$hold = [2,3,5,9,11,13];

if( count($leaders) > count($hold) ){
	$diff = count($hold) - count($leaders);
	$last = $hold[count($hold) - 1];
	for($i = 0; $i < $diff; $i++){
		$last += 2;
		$hold[] = $last;
	}
}

$totalStaff = count($leaders) + count($staff);
?>

<div class="ourpeople-section">
    <div class="row">
        <div class="large-12 columns">
            <?php if ($leadership['title']): ?>
            <h3 class="text-center"><?php echo $leadership['title']; ?></h3>
            <?php endif; ?>
        </div>
    </div>

    <div class='row collapse'>
        <table>
            <tr>
                <?php 
                    for($i = 0; $i < $totalStaff; $i++): 
                    if( in_array($i, $hold) ){
                        $next = array_shift($leaders);
                    } else {
                        $next = array_shift($staff);
                    }
                ?>
                <td class="person columns">
                    <table>
                        <tr>
                            <td class="hover-content-container">
                                <div class="small-12 column" style="background-image: url('<?php echo $next['headshot']['url']; ?>');"></div>
                                <div class="small-12 column text-bg">
                                    <table class="text-section">
                                        <tr>
                                            <td>
                                                <p class="leader-name"><?php echo $next['first_name']; ?></p>
                                                <p class="leader-name"><?php echo $next['last_name']; ?></p>
                                                <p class="leader-title"><?php echo $next['title']; ?></p>
                                                <?php if ($next['linkedin_link']): ?>
                                                <div class="leader-linkedin">
                                                    <a href="<?php echo $next['linkedin_link']; ?>" target="_blank"><i class="fa fa-linkedin-square" aria-hidden="true"></i></a>
                                                </div>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    </table>
                                </div>                
                            </td>
                        </tr>
                    </table>
                </td>
                <?php 
                    endfor; 
                ?>
            </tr>
        </table>
    </div>
</div>

<?php $json_leadership = json_encode($leadership['personnel'])?>
<?php endif; ?>

<div id="ourpeople-loadmore" class='row text-center'>
    <table style="width:100%">
        <tr style="display:none">
            <td style="width:100%;padding:0">
                <div class="" style="min-width:100%;height:200px; background: linear-gradient(transparent,#fff); margin-top:-240px;"></div>
            </td>
        </tr>
        <tr>
            <td style="width:100%;background-color:#fff">
                <div class="" style="min-width:100%;">
                    more<br/><i class="fa fa-angle-down" aria-hidden="true"></i><i class="fa fa-angle-down" aria-hidden="true"></i><i class="fa fa-angle-down" aria-hidden="true"></i>
                </div>
            </td>
        </tr>
    </table>
</div>

<?php 
$highlights = get_field('highlights');
if ($highlights): 
?>

<div class="number-section">      
    <?php foreach ($highlights['statistics'] as $i => $statistic): ?>
    <?php if ($i == 0 || $i == 3) {
        echo "<div class='row text-center top-row align-middle'>";
    } ?>
    <div class="small-6 medium-4 columns">
        <div class="grid-item hidden one">
            <div class="number">
            <?php echo $statistic['quantity']; ?>
            </div>
            <div class="subtitle">
            <?php echo $statistic['measure']; ?>
            </div>
        </div>
    </div>
    <?php if ($i == 2 || $i == 5) {
    echo "</div>";
    } ?>
    <?php endforeach; ?>
</div>

<div class="number-section-mobile">      
    <?php foreach ($highlights['statistics'] as $i => $statistic): ?>
    <?php if ($i == 0 || $i == 2 || $i == 4) {
        echo "<div class='row text-center top-row align-middle'>";
    } ?>
    <div class="small-6 medium-4 columns">
        <div class="grid-item one">
            <div class="number">
            <?php echo $statistic['quantity']; ?>
            </div>
            <div class="subtitle">
            <?php echo $statistic['measure']; ?>
            </div>
        </div>
    </div>
    <?php if ($i == 1 || $i == 3 || $i == 5) {
    echo "</div>";
    } ?>
    <?php endforeach; ?>
</div>

<?php endif; ?>

<div class="about-carousel">
    <?php foreach (get_field('carousel') as $i => $image): ?>
    <?php echo wp_get_attachment_image($image['id'], array(0,700), '', array( "class" => "carousel-image" )); ?>
    <?php endforeach; ?>
</div>

<?php get_template_part('partials/get-in-touch'); ?>
<?php get_footer(); ?>

<script>
jQuery(document).ready(function() {	
    function pauseVideo(){
        jQuery('.reveal-overlay').each(function(){
            if(jQuery(this).is(':hidden')){
                jQuery(this).find('iframe').vimeo("pause");
            }
            //console.log('checking');
        });
    }

    window.setInterval(pauseVideo, 750);   
});
</script>