<?php get_header(); ?>

<?php $heroimage = get_field('hero_image'); ?>
<div class="page-hero-block career-hero" style="background-image:url('<?php echo $heroimage['sizes']['large']; ?>')">
  <div class="row">
    <div class="page-hero-inner">
      <h1 class="page-hero">We’re looking for great people who want to do great things.</h1>
    </div>
  </div>
</div>

<div class="career-intro-section">
  <div class="row">
    <div class="large-12 columns text-center">
      <h2 class="career-intro-heading">Do you have what it takes?</h2>
      <p class="career-intro-text">We’re always open to meeting interesting new people that want to do great work and make a difference for our clients and our agency. Check below to take a look at our current openings, or send your résumé or portfolio to:</p>
      <a class="career-email" href="mailto:careers@handlpartners.com">careers@handlpartners.com</a>
    </div>
  </div>

  <div class="row intern-cta-section">
    <div class="large-12 columns text-center">
      <h3 class="intern-cta-text">Looking for an H&L internship? <a class="intern-cta-link" href="/internship">Click here</a> to learn more.</h3>
    </div>
  </div>
</div>

<div class="position-list-section">

  <div class="row">
    <div class="career-heading left-section">
      <p class="career-table-heading">Open Positions</p>
    </div>
    <div class="career-heading middle-section text-left">
      <p class="career-table-heading">Office</p>
    </div>
    <div class="career-heading right-section text-right">
      <p class="career-table-heading">Posting Date</p>
    </div>
  </div>


  <?php
  $args = [
      'post_type' => 'career',
      'posts_per_page' => 10,
      'order' => 'desc'
  ];
  $loop = new WP_Query($args);
  while ($loop->have_posts()) {
      $loop->the_post(); ?>

      <a href="<?php echo get_permalink( $post->ID ); ?>"><div class="row career-hover">

        <div class="career-item left-section">
          <p class="career-name"><?php the_title(); ?></p>
        </div>
        <div class="career-item middle-section text-left">
          <p class="career-location"><?php the_field('location'); ?></p>
        </div>
        <div class="career-item right-section text-right">
          <p class="career-date"><?php the_time('m.d.Y') ?></p>
        </div>
      </div></a>

      <?php
      wp_reset_postdata();
  }
  ?>
</div>














<?php get_footer(); ?>