<?php get_header(); ?>

<div class="page-hero-block viewpoint-hero">
  <div class="row">
    <div class="page-hero-inner">
      <h1 class="page-hero viewpoint-hero">Strong results start with smart thinking.</h1>
      <p class="page-hero-sub">Welcome to Viewpoint. In here, it’s all about our insights into market trends in Franchise Retail and Destination Travel. Take a look around. Arm yourself with some useful information. Or, if you don’t see exactly what you’re looking for, let us know and maybe we can partner together to generate it.</p>
    </div>
  </div>
</div>
<!--
<div class="row about-hero-padding">
  <div class="medium-8 columns">
    <h1 class="page-hero whitepaper-hero">Strong results start with smart thinking.</h1>
    <h2 class="viewpoint-subtext">Welcome to Viewpoint. In here, it’s all about our insights into market trends in Franchise Retail and Destination Travel. Take a look around. Arm yourself with some useful information. Or, if you don’t see exactly what you’re looking for, let us know and maybe we can partner together to generate it.</h2>
  </div>
</div> -->


<div id="tab-container" class="row filter-tab-container expanded collapse">

  <div class="large-12 columns">

    <div data-sticky-container>
      <ul style="width:100%" class="filter-tabs sticky row align-center collapse expanded" data-sticky data-anchor="tab-container" data-sticky-on="small" data-margin-top="<?php echo (is_admin_bar_showing()) ? '6.4' : '4.6';?>">
        <li class="tabs-title active"><a href="" data-filter="*">All<span class="hide-for-small-only"> Insights</span></a></li>
        <li class="tabs-title"><a href="" data-filter=".ind-retail-franchisor">Retail / <wbr>Franchise</a></li>
        <li class="tabs-title"><a href="" data-filter=".ind-destination-travel">Travel / <wbr>Tourism</a></li>
      </ul>
    </div>

    <div class="whitepapers-container">
      <div class="row large-up-3 medium-up-2 small-up-1 filter-grid" style="margin:0 auto;">
        <?php
        $args = [
            'post_type' => 'whitepaper',
            'posts_per_page' => -1,
        ];
        $loop = new WP_Query($args);
        while ($loop->have_posts()) {
            $loop->the_post();

            if ( has_post_thumbnail() ) {
                $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large' );
                $whitepaperimage = $large_image_url[0];
           }
            $industry_classes = get_industry_classes($post->ID);
        ?>
          <div class="column column-block filter-item <?php echo $industry_classes; ?>">
            <a class="whitepaper-item-link" href="<?php the_permalink(); ?>">
              <div class="whitepaper-block">
                <div class="whitepaper-thumb" style="background-image:url('<?php echo $whitepaperimage; ?>'); background-size: cover; background-repeat:no-repeat; background-position: center center;"></div>

                <div class="whitepaper-content">
                  <div class="whitepaper-text-section">
                    <p class="whitepaper-title"><?php the_title(); ?></p>
                    <div class="whitepaper-excerpt"><?php the_excerpt(); ?></div>
                  </div>
                </div>
              </div>
            </a>
          </div>

          <?php
          wp_reset_postdata();
        }
        ?>
      </div>

    </div>
  </div>
</div>

<!-- <div class="post-btns post-padding whitepaper-btn">
  <div class="row text-center">
    <div class="small-12 columns">
      <a class="btn btn-posts whitepaper-btn" href="/">Load More</a>
    </div>
  </div>
</div> -->

<?php get_template_part( 'partials/get-in-touch' ); ?>

<?php get_footer(); ?>
