<?php get_header(); ?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div class="page-hero-block single-work-hero">
  <div class="row">
    <div class="page-hero-inner">
      <p class="campaign-client-title"><?php the_field('client'); ?></p>
      <h1 class="campaign-title"><?php echo get_the_title(); ?></h1>
    </div>
  </div>
</div>

<?php $backgroundImg = get_field('hero_image'); ?>
<?php echo wp_get_attachment_image( $backgroundImg['id'], 'full', '', array( "class" => "work-hero" ) ); ?>


<?php if (get_the_content()): ?>
  <div class="row work-detail-padding">
  	<div class="large-12 columns text-center">    
	<h4 class="campaign-subtitle">The Campaign</h4>
    <h3 class="campaign-heading"><?php the_field('subheading'); ?></h3>
        <div class="campaign-text">
             <?php the_content(); ?>
        </div>
    <?php else: ?>
      <?php the_excerpt(); ?>
	  <!-- <ul class="flat-list social-list work-social-list">
      <li>
        <a href="#"><i class="fa fa-twitter" aria-hidden="true"></i></a>
      </li>
      <li>
        <a href="#"><i class="fa fa-facebook" aria-hidden="true"></i></a>
      </li>
      <li>
        <a href="#"><i class="fa fa-linkedin" aria-hidden="true"></i></a>
      </li>
    </ul> -->

  <?php endif; ?>
  </div>
</div>

<?php
// check if the flexible content field has rows of data
if( have_rows('flex') ):

    $section = 0;
    // loop through the rows of data
    while ( have_rows('flex') ) : the_row();
        $section = 1;
        if( get_row_layout() == 'default' ):
          $options = get_sub_field('options');
          ?>

            <div class="default-panel panel-padding <?php echo $options['color_scheme']; ?>">

              <?php if ($options['orientation'] == 'below') : ?>

                <div class="row default-orientation-below">
                  <div class="large-12 columns text-center">
                    <?php if (get_sub_field('headline')): ?>
                      <h4 class="headline panel-subtitle"><?php the_sub_field('headline'); ?></h4>
                    <?php endif; ?>
                    <?php if (get_sub_field('body')): ?>
                      <div class="body panel-text"><?php the_sub_field('body'); ?></div>
                    <?php endif; ?>
                  </div>
                </div>

                <?php
                $images = get_sub_field('images');

                if( $images ): ?>
                  <div class="row default-orientation-below-images small-collapse large-collapse">
                    <?php foreach( $images as $image ): ?>
                      <div class="columns text-center">
                        <?php echo wp_get_attachment_image( $image['id'], 'full' ); ?>
                      </div>
                    <?php endforeach; ?>
                  </div>
                <?php endif; ?>

              <?php elseif ($options['orientation'] == 'above') : ?>

                <?php
                  $images = get_sub_field('images');

                  if( $images ): ?>
                    <div class="row default-orientation-above-images small-collapse large-collapse">
                      <?php foreach( $images as $image ): ?>
                        <div class="columns text-center">
                          <?php echo wp_get_attachment_image( $image['id'], 'full' ); ?>
                        </div>
                      <?php endforeach; ?>
                    </div>
                  <?php endif; ?>

                <div class="row default-orientation-above">
                  <div class="large-12 columns text-center">
                    <?php if (get_sub_field('headline')): ?>
                      <h4 class="headline panel-subtitle image-above-margin"><?php the_sub_field('headline'); ?></h4>
                    <?php endif; ?>
                    <?php if (get_sub_field('body')): ?>
                      <div class="body panel-text"><?php the_sub_field('body'); ?></div>
                    <?php endif; ?>
                  </div>
                </div>

              <?php elseif ($options['orientation'] == 'no-images') : ?>

                <div class="row default-no-images">
                  <div class="large-12 columns text-center">
                    <?php if (get_sub_field('headline')): ?>
                      <h4 class="headline panel-subtitle"><?php the_sub_field('headline'); ?></h4>
                    <?php endif; ?>
                    <?php if (get_sub_field('body')): ?>
                      <div class="body panel-text"><?php the_sub_field('body'); ?></div>
                    <?php endif; ?>
                  </div>
                </div>

              <?php elseif ($options['orientation'] == 'left') : ?>

                <div class="row default-orientation-left">
                  <?php
                  $images = get_sub_field('images');

                  if( $images ): ?>
                    <div class="large-6 columns">
                      <div class="row">
                        <?php foreach( $images as $image ): ?>
                          <div class="columns text-center">
                            <?php echo wp_get_attachment_image( $image['id'], 'full' ); ?>
                          </div>
                        <?php endforeach; ?>
                      </div>
                    </div>
                  <?php endif; ?>

                  <div class="large-6 columns">
                    <div class="row">
                      <div class="large-12 columns text-center">
                        <?php if (get_sub_field('headline')): ?>
                          <h4 class="headline panel-subtitle"><?php the_sub_field('headline'); ?></h4>
                        <?php endif; ?>
                        <?php if (get_sub_field('body')): ?>
                          <div class="body panel-text"><?php the_sub_field('body'); ?></div>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>
                </div>

              <?php elseif ($options['orientation'] == 'right') : ?>

               <div class="row default-orientation-right align-middle">
                 <div class="large-6 columns text-center">
                   <?php if (get_sub_field('headline')): ?>
                     <h4 class="headline panel-subtitle"><?php the_sub_field('headline'); ?></h4>
                   <?php endif; ?>
                   <?php if (get_sub_field('body')): ?>
                     <div class="body panel-text"><?php the_sub_field('body'); ?></div>
                   <?php endif; ?>
                 </div>

                 <?php
                 $images = get_sub_field('images');

                 if( $images ): ?>
                   <div class="large-6 columns text-center">
                     <div class="row">
                       <?php foreach( $images as $image ): ?>
                         <div class="columns text-center">
                           <?php echo wp_get_attachment_image( $image['id'], 'full' ); ?>
                         </div>
                       <?php endforeach; ?>
                     </div>
                   </div>
                 <?php endif; ?>
               </div>

              <?php endif; ?>

            </div>

        <?php
        elseif( get_row_layout() == 'full_width_image' ):

          $image = get_sub_field('image');

          if( $image ): ?>
            <div class="full-width-image" style="background-image: url(<?php echo $image['url']; ?>);height: <?php the_sub_field('height'); ?>px;"></div>

          <?php endif; ?>

        <?php
        elseif( get_row_layout() == 'videos' ):

          $videos = get_sub_field('videos');

          if( $videos ): ?>
            <div class="video-slider">
              <div class="row">
                <div class="large-12 columns text-center">
                  <div class="video-player">
                    <?php
                    $video = $videos[0];
				   //$groupnumber = the_sub_field('group_number');
				   if( $videos ): ?>

                    <div id='campaign-video-container-<?php the_sub_field('group_number'); ?>' class='video-item'>
                    	<?php echo do_shortcode('[fve]https://player.vimeo.com/video/' . $video['vimeo_id'] . '?portrait=0&byline=0&title=0&api=1&player_id=player-' . $groupnumber . '[/fve]') . "\n"?>
                    </div>
					<?php endif; ?>
                    <!--<div id="video-play-button-<?php the_sub_field('group_number'); ?>" class="video-icon-wrapper">
                      <div class="video-icon-container"><div class="play-icon"></div></div>
                    </div> -->

                  </div>
                  <div id="campaign-video-thumbs-<?php the_sub_field('group_number'); ?>" class="video-thumbs">
                    <?php
                    $first = true;
                    foreach( $videos as $video ):
                      $imgid = $video['vimeo_id'];
                    	 $group = $video['group_number'];
                      $hash = unserialize(file_get_contents("http://vimeo.com/api/v2/video/$imgid.php"));
                      // var_dump($hash);
                      echo "<a id='campaign-video-{$imgid}-{$group}' class='campaign-thumb-link";
                      if ($first) echo " active";
                      echo "' href='javascript:loadCampaignVideo({$imgid},{$group})'><img src='" . $hash[0]['thumbnail_small'] . "'></a>\n";
                      $first = false;
                    endforeach;
                    ?>
                  </div>
                </div>
              </div>
            </div>
          <?php endif;

        endif;
        $section++;
    endwhile;

else :

    // no layouts found

endif;
?>





<?php endwhile; else : ?>

    <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>

<?php endif; ?>


<div class="more-work-section">
  <div class="row align-justify align-middle more-work-border collapse">
    <div class="shrink">
      <p><a class="more-work-link" href="">More Work</a></p>
    </div>
    <div class="columns shrink align-justify" style="right:0;text-align:right">
      <p><a class="see-all" href="/work/">See All Work</a></p>
    </div>
  </div>

<?php
$query = new WP_Query(
  [
  'post_type' => 'campaign',
  'posts_per_page' => 2,
  'post__not_in' => [get_the_id()],
  'orderby' => 'rand',
  ]
);
if ( $query->have_posts() ) : ?>
  <div class="row align-justify collapse">
    <?php while ( $query->have_posts() ) : $query->the_post(); $poster_image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_id() ), array(520,0)); ?>
      <div class="large-6 columns more-work-column">
        <a href="<?php the_permalink(); ?>">
          <div class="more-poster-image" style="background-image: url(<?php echo $poster_image[0]; ?>);"></div>
          <div class="more-work-text">
            <p class="subtitle"><?php the_field('client'); ?></p>
            <p class="title"><?php the_title(); ?></p>
          </div>
        </a>
      </div>
    <?php endwhile; wp_reset_postdata(); ?>
  </div>
<?php endif; ?>
</div>


<?php get_template_part( 'partials/get-in-touch' ); ?>

<?php get_footer(); ?>