<?php get_header(); ?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div class="page-hero-block single-career-hero">
  <div class="row">
    <div class="page-hero-inner">
      <h1 class="page-hero"><?php echo get_the_title(); ?></h1>
    </div>
  </div>
</div>

<div class="row single-post-padding career-post-padding">

  <div class="small-12 small-order-1 large-order-2 large-8 columns">
    <h4 class="post-subtitle-heading"><?php the_field('career_heading'); ?></h4>

    <div class="career-content">
      <?php if (get_the_content()): ?>
          <div class="post-content">
               <?php the_content(); ?>
          </div>
      <?php else: ?>
           <?php the_excerpt(); ?>
      <?php endif; ?>

      <?php endwhile; else : ?>

          <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>

      <?php endif; ?>
    </div>

    <div class="footer-btn post-padding career-padding">
      <div class="row text-center">
        <div class="large-12 columns">
          <a class="btn btn-posts btn-career" href="/careers">Back to Careers</a>
        </div>
      </div>
    </div>
  </div>

  <div class="small-12 small-order-2 large-3 large-order-1 columns">
    <div class="sidebar-section share-side">
      <h4 class="post-sidebar-heading share-heading">Share This</h4>
      <div data-network="twitter" class="st-custom-button" st_via='@HandLPartners' st_username='H&amp;L Partners' st_title='<?php the_title(); ?>' st_url='<?php the_permalink(); ?>'><i class="fa fa-twitter" aria-hidden="true"></i></div>
      <div data-network="facebook" class="st-custom-button" st_title='<?php the_title(); ?>' st_url='<?php the_permalink(); ?>'><i class="fa fa-facebook" aria-hidden="true"></i></div>
      <div data-network="linkedin" class="st-custom-button" st_title='<?php the_title(); ?>' st_url='<?php the_permalink(); ?>'><i class="fa fa-linkedin" aria-hidden="true"></i></div>
    </div>

    <div class="sidebar-section">
      <h4 class="post-sidebar-heading">Location</h4>
      <p class="post-sidebar-meta"><?php the_field('location'); ?></p>
    </div>

    <div class="sidebar-section">
      <h4 class="post-sidebar-heading">Date Posted</h4>
      <p class="post-sidebar-meta"><?php the_time(' F jS, Y') ?></p>
    </div>
  </div>
</div>


<?php get_footer(); ?>