<?php 
@session_start();

$pardot_post = "https://go.pardot.com/l/124971/2017-12-07/23bp1y";

$pardot = get_query_var("pardot");
$whitepaper = get_query_var("whitepaper");

$firstname = hlp_get_input("firstname","post","");
$lastname = hlp_get_input("lastname","post","");
$company = hlp_get_input("company","post","");
$email = hlp_get_input("email","post","");

$firstError = false;
$lastError = false;
$emailError = false;

$errors = [];

if( isset($_POST["submit-pardot"] ) ){
    if( empty($firstname) ){
        $firstError = true;
        $errors[] = "Your first name is required";
    }
    if( empty($lastname) ){
        $lastError = true;
        $errors[] = "Your last name is required";
    }
    if( empty($email) ){
        $emailError = true;
        $errors[] = "Your email is required";
    }
    else if ( !filter_var($email, FILTER_VALIDATE_EMAIL) ) {
        $emailError = true;
        $errors[] = "Your email is invalid";
    }
}

if( empty($errors) && isset($_POST["submit-pardot"]) ){
    $fields = [
        "firstname" => $firstname,
        "lastname" => $lastname,
        "company" => $company,
        "email" => $email
    ];

    foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
    rtrim($fields_string, '&');

    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL, $pardot_post);
    curl_setopt($ch,CURLOPT_POST, count($fields));
    curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
    
    $result = curl_exec($ch);
    curl_close($ch);

    if( strpos($result,"required") !== false ){
        $errors[] = "Sorry, there was a problem processing your request";
    } else {
        $_SESSION["pardot_validated"] = true;
        session_write_close();

        header("location: http://$_SERVER[HTTP_HOST]/viewpoint/$whitepaper/thank-you");
        die();
    }
}

get_header();
?>

<style>
#pardot-form {
    background: #90c2c5;
    padding: 30px 30px 15px;
    color: #FFF;
    max-width: 420px;
}

#pardot-form .error input {
    border: #ffa409 2px solid;
}

#pardot-form .submit {
    width: 100%;
    color: #FFF;
    background: #ffa409;
    -webkit-transition: none;
    border: 0;
    margin-bottom: 0;
    margin-top: 20px;
    font-size: 18px;
    font-weight: bold;
    line-height: 1.5;
    height: 60px;
    transition: background .3s;
    display: block;
    padding: 1em;
    text-align: center;
    text-transform: uppercase;
}

#pardot-form #errorMessage {
    line-height: 1.25;
    color: #fff;
    font-weight: bold;
}
</style>

<div class="row whitepaper-section collapsed">
    <div class="small-12 medium-12 large-8 columns whitepaper-download-left">
        <div class="whitepaper-subtitle">FREE Whitepaper</div>
        <h1 class="whitepaper-page-title"><?php echo get_the_title(); ?></h1>
        <div class="whitepaper-content-area">
            <div class="whitepaper-image">
                <img src="<?php echo get_bloginfo('template_directory');?>/img/whitepapermock.png" alt="">
            </div>
            <div class="whitepaper-text-area">
                <?php if (have_posts()) : while (have_posts()) : the_post();?>
                <?php the_content(); ?>
                <?php endwhile; endif; ?>
            </div>
        </div>
    </div>

    <div class="small-12 medium-12 large-4 columns whitepaper-download-right">
        <div class="intern-form">
            <div role="form" id="pardot-form" lang="en-US" dir="ltr">
                <form action="" method="post">
                    <input type="hidden" name="whitepaper" value="<?php echo $whitepaper; ?>" />
                    <p class="program-form-heading">Whitepaper Download</p>

                    <?php if( empty($_SESSION["pardot_validated"]) ): ?>
                    <p class="program-form-subheading">Please complete the fields below</p>
                    <p>
                        <div class="<?php if($firstError){ echo 'error'; } ?>">
                            <input type="text" name="firstname" placeholder="First Name" value="<?php echo $firstname; ?>" size="40" required />
                        </div>
                    </p>
                    <p>
                        <div class="<?php if($lastError){ echo 'error'; } ?>">
                            <input type="text" name="lastname" placeholder="Last Name" value="<?php echo $lastname; ?>" size="40" required />
                        </div>
                    </p>
                    <p>
                        <div>
                            <input type="text" name="company" placeholder="Company" value="<?php echo $company; ?>" size="40" />
                        </div>
                    </p>
                    <p>
                        <div class="<?php if($emailError){ echo 'error'; } ?>">
                            <input type="email" name="email" placeholder="Email Address" value="<?php echo $email; ?>" size="40" required />
                        </div>
                    </p>
                    <div id="errorMessage"><?php echo implode("<br/>", $errors); ?></div>
                    <div class="form-button">
                        <input type="submit" name="submit-pardot" value="Download Now" class="submit">
                    </div>
                    <?php else: ?>
                        <p>Thank you for registering!</p>
                        <a href="<?php echo "http://$_SERVER[HTTP_HOST]/viewpoint/$whitepaper/thank-you"; ?>" class="submit">Download Now</a>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="text-cta white-paper-cta">
    <div class="row text-center">
        <div class="small-12 columns">
        We’re <a class="text-cta-url" href="/">H&L Partners</a>, a full-service advertising agency with offices in San Francisco, St. Louis, Boston, 
        Richmond, and Lexington. We develop high-performance advertising, marketing, and promotional programs that help our clients outperform the 
        competition. We'd love to hear from you. Get in <a class="text-cta-url" href="/contact">touch</a>.
        </div>
    </div>
</div>

<?php get_footer(); ?>