<?php get_header(); ?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<?php $heroimage = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' ); ?>
<div class="page-hero-block news-hero" style="background-image:url('<?php echo $heroimage[0]; ?>')">
  <div class="row">
    <div class="page-hero-inner">
      <h1 class="page-hero"><?php echo get_the_title(); ?></h1>
    </div>
  </div>
</div>


<div class="row single-post-padding">
  <div class="small-12 small-order-2 large-3 large-order-1 columns">
    <div class="sidebar-section share-side">
      <h4 class="post-sidebar-heading share-heading">Share This</h4>
      <div data-network="twitter" class="st-custom-button" st_via='@HandLPartners' st_username='H&amp;L Partners' st_title='<?php the_title(); ?>' st_url='<?php the_permalink(); ?>'><i class="fa fa-twitter" aria-hidden="true"></i></div>
      <div data-network="facebook" class="st-custom-button" st_title='<?php the_title(); ?>' st_url='<?php the_permalink(); ?>'><i class="fa fa-facebook" aria-hidden="true"></i></div>
      <div data-network="linkedin" class="st-custom-button" st_title='<?php the_title(); ?>' st_url='<?php the_permalink(); ?>'><i class="fa fa-linkedin" aria-hidden="true"></i></div>
    </div>

    <div class="sidebar-section">
      <h4 class="post-sidebar-heading">Category</h4>
      <p class="post-sidebar-meta"><?php foreach((get_the_category()) as $category) { echo $category->cat_name . ' '; } ?></p>
    </div>

    <div class="sidebar-section">
      <h4 class="post-sidebar-heading">Date Posted</h4>
      <p class="post-sidebar-meta"><?php the_time(' F jS, Y') ?></p>
    </div>
  </div>

  <div class="small-12 small-order-1 large-order-2 large-8 columns">

    <?php if (get_the_content()): ?>
        <div class="post-content">
             <?php the_content(); ?>
        </div>
    <?php else: ?>
         <?php the_excerpt(); ?>
    <?php endif; ?>

    <?php endwhile; else : ?>

        <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>

    <?php endif; ?>
  </div>
</div>

<div class="more-work-section">
  <div class="row align-justify more-work-border collapse">
    <div class="shrink">
      <p><a class="more-work-link" href="/news/">More News</a></p>
    </div>
    <div class="columns shrink align-justify">
        <p><a class="see-all" href="/news/">See All News</a></p>
    </div>
  </div>

<?php
$query = new WP_Query(
  [
  'post_type' => 'post',
  'posts_per_page' => 2,
  'post__not_in' => [get_the_id()],
  'orderby' => 'rand',
  ]
);
if ( $query->have_posts() ) : ?>
  <div class="row align-justify collapse">
    <?php while ( $query->have_posts() ) : $query->the_post(); $poster_image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_id() ), array(520,0)); ?>
      <div class="large-6 columns more-work-column">
        <a href="<?php the_permalink(); ?>">
          <div class="more-poster-image" style="background-image: url(<?php echo $poster_image[0]; ?>);"></div>
          <div class="more-work-text">
            <p class="subtitle"><?php the_field('client'); ?></p>
            <p class="title"><?php the_title(); ?></p>
          </div>
        </a>
      </div>
    <?php endwhile; wp_reset_postdata(); ?>
  </div>
<?php endif; ?>

</div>

<?php get_template_part( 'partials/get-in-touch' ); ?>

<?php get_footer(); ?>