<?php 
/**
 * Template Name: Expertise Page
 *
 * @package WordPress
  */
get_header(); ?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

  <?php if (get_field('header')): ?>
    <div class="page-hero-block expertise-hero">
      <div class="row">
        <div class="page-hero-inner">
          <h1 class="page-hero fade-in"><?php the_field('header'); ?></h1>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <div class="video-player">
    <?php
      echo "<div id='expertise-video-container' class='video-item'>\n";
      ?>
      <div class="fve-video-wrapper fve-image-embed fve-thumbnail-image vimeo" style="padding-bottom:56.25%;">
          <iframe src="//player.vimeo.com/video/<?php the_field('video_id'); ?>?portrait=0&byline=0&title=0" width="100%" height="100%" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
      </div>
      <?php
      echo "</div>\n";
    ?>
    <div id="video-play-button" class="video-icon-wrapper">
      <div class="video-icon-container"><div class="play-icon"></div></div>
    </div>
  </div>


  <?php $intro = get_field('intro');
  if ($intro): ?>
    <div class="expertise-intro-section">
      <div class="row">
        <div class="large-12 columns text-center">
          <?php if ($intro['title']): ?>
            <h3><?php echo $intro['title']; ?></h3>
          <?php endif; ?>
          <?php if ($intro['body']): ?>
            <?php echo $intro['body']; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <?php $campaign_list = get_field('campaign_list');
  if ($campaign_list): ?>
    <div class="expertise-campaign-list-section">
      <div class="row campaign">
        <div class="large-12 columns text-center">
          <?php foreach ($campaign_list as $i => $campaign): ?>
            <div class="row campaign">
              <div class="small-12 medium-6 columns campaign-info <?php if ($i % 2 != 0) echo "medium-order-2"; ?>">
                <h3><?php echo $campaign['title']; ?></h3>
                <?php echo $campaign['body']; ?>
                <a href="<?php echo get_permalink($campaign['campaign'][0]-> ID); ?>">See the campaign</a>
              </div>
              <div class="small-12 medium-6 columns campaign-image <?php if ($i % 2 != 0) echo "medium-order-1"; ?>" style="background-image: url(<?php echo $campaign['image']['url']; ?>);">
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <div class="text-cta expertise-cta">
    <div class="row text-center">
      <div class="small-12 columns">
        <?php the_field('cta'); ?>
      </div>
    </div>
  </div>


<?php endwhile; ?>
<?php endif; ?>

<?php get_footer(); ?>