<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>H&L Lovin' It | Baked Goods</title>
    <meta name="description" content="">
	<meta name="robots" content="noindex, nofollow" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="../assets/css/foundation.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/js/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="../assets/js/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/styles.css">
    <script type="text/javascript" src="../assets/js/jquery.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/gsap/latest/TweenMax.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ScrollMagic/2.0.3/ScrollMagic.js"></script>
    <script type="text/javascript" src="../assets/js/animation.gsap.js"></script>
    <script type="text/javascript" src="../assets/js/stellar.min.js"></script>
    <script type="text/javascript" src="../assets/js/foundation.min.js"></script>
    <script type="text/javascript" src="../assets/js/jquery.animateNumber.min.js"></script>
    <script type="text/javascript" src="../assets/js/app.js"></script>
    <script type="text/javascript" src="../assets/js/slick/slick.min.js"></script>
</head>
<body>

<?php include_once "../header.php"; ?>

<div id="wrapper">
    <div class="row">
      <div class="small-12 columns">
          <h1 class="case-study-h1">MCDONALD'S</h1>
          <h2  class="case-study-h2">Baked Goods</h2>
      </div>
    </div>
    <div class="row panel-image">
      <div class="small-12 columns drink-run1">
          <img src="../assets/images/case-study1.jpg"/>
      </div>
    </div>
    <div class="row panel-text drink-run2">
      <div class="small-12 columns">
          <div>
              <div class="impact">
                  <div class="line"><div></div></div>THE OPPORTUNITY<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              Launching muffins key to slamming Dunkin'
              <p>Baked goods is the largest breakfast food category, and to steal customers from Dunkin' Donuts in New England, we needed to get in the game with a strong offering. Introducing a line of easy to prepare muffins was phase one.</p>
          </div>
      </div>
    </div>
    <div class="row panel-slider drink-run3">
        <div class="spacer small-12 columns">&nbsp;
        </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="medium-12 large-10 columns">
              <div class="slider slider-for">
					<div class="video">
                        <video playsinline poster="../assets/images/CaseStudyPhotos/bakedgoods-thumb-video.jpg">
                            <source src="https://player.vimeo.com/external/211721657.hd.mp4?s=38e9f2a458fe1ba1422680b82e0015de1a3fb770&profile_id=174" type="video/mp4">
                        </video>
                	</div>
                    <div class="image">
                        <img src="../assets/images/CaseStudyPhotos/bakedgoods-OOH.jpg"/>
                    </div>
                    <div class="radio">
                        <img src="../assets/images/CaseStudyPhotos/radio-bg.jpg"/>
                        <audio>
                              <source src="../assets/mp3/bakedgoods.mp3" type="audio/mpeg">
                              <source src="../assets/mp3/bakedgoods.wav" type="audio/wav">
                              <source src="../assets/mp3/bakedgoods.ogg" type="audio/ogg">
                        </audio>
                	</div>
                    <div class="video">
                        <video playsinline>
                            <source src="https://player.vimeo.com/external/211713052.hd.mp4?s=ffc206d4cc3f4b5a9e2ef3ccf3ee65c80a02bcbc&profile_id=174" type="video/mp4">
                        </video>
                	</div>
                    <div class="image">
                        <img src="../assets/images/CaseStudyPhotos/bakedgoods-window-poster.jpg"/>
                    </div>
				</div>
				<div class="slider slider-nav">
                    <div><img src="../assets/images/CaseStudyPhotos/bakedgoods-thumb-video.jpg"/><p>TV</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/bakedgoods-OOH.jpg"/><p>OOH</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/thumb-radio.jpg"/><p>Radio</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/bakedgoods-thumb-MenuBoard.jpg"/><p>Menu Board</p></div>
                    <div><img src="../assets/images/CaseStudyPhotos/bakedgoods-thumb-window.jpg"/><p>Merchandising</p></div>
				</div>

          </div>
          <div class="desktop small-0 medium-0 large-1 columns">&nbsp;
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
    </div>
    <div class="row panel-text drink-run4 impact-red">
      <div class="small-12 columns">
          <div class="wider">
              <div class="impact impact-red">
                  <div class="line"><div></div></div>IMPACT<div class="line2"><div></div></div>
              </div>
              <br clear="all">
              <p>Restaurants in New England are selling between 150 and 300 units per week, and operators are delighted with the simple ops procedures.</p>
          </div>
          <div class="spacer small-12 columns">&nbsp;
          </div>
      </div>
    </div>
</div>

<?php include_once "../footer.php"; ?>
<script>

var controller = new ScrollMagic.Controller();

    var tl = new TimelineLite({paused:true});
    tl.to($('.drink-run2 .line div'), 2, {width:'100%'});
    tl.to($('.drink-run2 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run2",duration:200})
        .addTo(controller)
        .setTween(tl.play());

    var tl2 = new TimelineLite({paused:true});
    tl2.to($('.drink-run4 .line div'), 2, {width:'100%'});
    tl2.to($('.drink-run4 .line2 div'), 2, {width:'100%'},"-=2");
    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run4",duration:200})
        .addTo(controller)
        .setTween(tl2.play());

    var scene7 = new ScrollMagic.Scene({triggerElement: ".drink-run4"})
        .on('start', function () {
            $('#number1').prop('number', 500).animateNumber({ number: 888 },1000);
        })
        .reverse(false)
        .addTo(controller);

        var scene7 = new ScrollMagic.Scene({triggerElement: ".slider-for"})
            .on('start', function () {
                function isTouchDevice() {
                    return 'ontouchstart' in document.documentElement;
                }
                if (isTouchDevice()) {
                    $('.slider-for .slick-current').find('.play-btn').fadeIn();
                } else {
                    $('.slider-for .slick-current').children('video').get(0).play();
                }
            })
            .reverse(false)
            .addTo(controller);
</script>
</body>
</html>
