<?php
/**
 * Template Name: What We Do - Case Studies Thank You
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since H&L Partners 1.0
 */

get_header();
hlp_load_functions("models");

$mode = get_query_var("display_mode");
$slug = get_query_var("case_slug");
$case = hlp_case_studies_detail($slug,TRUE);
$download = $case->download;

$banner = "";
if( !empty($case->images) ){
	$banner = $case->images[0]->src;
}

if( !empty( $banner ) ):
?>

<div id="page-banner" style="background-image:url(<?php echo $banner;?>);"></div>

<?php 
endif;
if( !empty($download) ):
?>

<div id="page-content" class="row gray">
    <div class="small-12 medium-3 large-3 columns">
        <h2>THANK YOU</h2>
    </div>
    <div class="small-12 medium-9 large-9 columns nopadleft">
        <p>Your download will begin shortly...</p>
        <script>
            jQuery(document).ready(function(){
                window.setTimeout(function(){
                    window.location = "<?php echo @$download;?>";
                },3000);
            });
        </script>

		<p>In the sections below you may also find interesting and relevant papers on different aspects of effective retail advertising beneficial to helping you
		with your marketing challenges. And if you would like to speak with someone live to learn more about H&amp;L Partners expertise
		in Retail/Franchise advertising, or just want to pick our brains, feel free to contact:</p>

		<?php if($_SESSION["region"] === "east"): ?>
			<p>Mark Schaeffer, <a href="tel:314-454-3400">314-454-3400</a> or <a href="mailto:mschaeffer@handlpartners.com">mschaeffer@handlpartners.com</a></p>
		<?php else: ?>
			<p>Andrea Alfano, <a href="tel:415-434-8500">415-434-8500</a> or <a href="mailto:andreaalfano@handlpartners.com">andreaalfano@handlpartners.com</a></p>
		<?php endif; ?>	

		<br/><br/>

    </div>
</div>

<?php else: ?>

<div id="page-content" class="row gray">
    <div class="small-12 medium-3 large-3 columns">
        <h2>SORRY</h2>
    </div>
    <div class="small-12 medium-9 large-9 columns nopadleft">
        <p>The case study you've requested could not be found or is no longer available.  
		Please <a href="/what-we-do/case-studies">click here</a> to return to the main Case Studies.</p>
    </div>
</div>

<?php endif; ?>

<div class="category-row row">
    <div class="small-12 columns">
        <div class="case-category clearfix">
            <div class="case-category-name">Retail / Franchise</div>
            <div class="case-category-tab"></div>
        </div>
    </div>
</div>

<div id="case-retail" class="case-study-grid row small-up-1 medium-up-2 large-up-3">
    <?php hlp_case_studies("franchise-retail",3); ?>
</div>

<div class="category-row row">
    <div class="small-12 columns">
        <div class="case-category clearfix">
            <div class="case-category-name">Destination Travel</div>
            <div class="case-category-tab"></div>
        </div>
    </div>
</div>

<div id="case-travel" class="case-study-grid row small-up-1 medium-up-2 large-up-3">
    <?php hlp_case_studies("destination-travel",3); ?>
</div>


<?php
get_footer();
