<?php get_header(); ?>

  <?php $hero = get_field('hero');
  if ($hero): ?>
    <div class="row collapse">
      <div class="large-12 columns">
        <div class="hero-section hero-mobile">
          <?php if ($hero['title']): ?>
            <h1 class="hero-text"><?php echo $hero['title']; ?></h1>
          <?php endif; ?>
          <?php if ($hero['cta']): ?>
            <a class="btn hero-btn" href="<?php echo $hero['cta']['url']; ?>"><?php echo $hero['cta']['title']; ?></a>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="home-hero-bg">
      <div class="home-video-container">
		<video class="home-video-iframe" autoplay loop muted playsinline poster="wp-content/uploads/2017/11/homepage-video-poster.png">
		 <source src="wp-content/uploads/2017/11/homepage-intro-video_compressed.mp4" type='video/mp4;'>
        </video>
	  </div>

  <!--      <iframe id="homevideo" class="home-video-iframe" src="//player.vimeo.com/video/<?php echo $hero['full_screen_video_id']; ?>?background=1&autoplay=0&loop=1&title=0&byline=0&portrait=0" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
      </div>
  <script src="https://player.vimeo.com/api/player.js"></script>
  <script>
    var player = new Vimeo.Player($('#homevideo'));
    player.ready().then(function() {
	    	player.play();
	});    
  </script> -->

      <div class="row align-middle hero-bg-overlay">
        <div class="hero-section">
          <?php if ($hero['title']): ?>
            <h1 class="hero-text"><?php echo $hero['title']; ?></h1>
          <?php endif; ?>
          <?php if ($hero['cta']): ?>
            <a class="btn hero-btn" href="<?php echo ($hero['cta']['url']) ? $hero['cta']['url'] : '#'; ?>"><?php echo $hero['cta']['title']; ?></a>
          <?php endif; ?>
        </div>
        <div class="hero-caret">
          <i class="fa fa-angle-down" aria-hidden="true"></i>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <?php $news_slider = get_field('news_slider');
  if ($news_slider): ?>
    <div class="home-slide-container">
      <div class="row columns">

          <div class="home-slider">
            <?php foreach ($news_slider as $i => $panel): ?>
              <div class="home-slide">
                <div style="padding:0;">
                  <?php if ($panel['title']): ?>
                    <div class="text-left slider-subtitle"><?php echo $panel['title']; ?></div>
                  <?php endif; ?>
                  <div class="slider-body">
                    <?php if ($panel['link'] && $panel['link']['url']): ?>
                      <a href="<?php echo $panel['link']['url']; ?>">
                    <?php endif; ?>
                        <?php echo $panel['body']; ?>
                    <?php if ($panel['body']): ?>
                      </a>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>

      </div>
    </div>
  <?php endif; ?>


  <?php $work_gallery = get_field('work_gallery');
  if ($work_gallery): ?>

    

      <?php foreach( $work_gallery as $i => $post): setup_postdata($post); ?>

       <?php if ($i == 0 || $i == 2) echo "<div class='row medium-up-2 small-up-1 gallery collapse expanded'>"; ?>
        <?php
          if ( has_post_thumbnail() ) {
            $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large' );
            $projectimage = $large_image_url[0];
          }
        ?>

        <div class="column column-block image-block campaign" style="background-image:url('<?php echo $projectimage; ?>')">
          <a href="<?php the_permalink(); ?>">
            <div class="campaign-inner">
              <div class="campaign-loader">
                <?php
                  $client_logo = get_field('client_logo');
                  if ( !empty($client_logo) ) {
                    echo "<img class=\"campaign-logo\" src=\"{$client_logo['url']}\">\n";
                  }
                ?>
              </div>
              <div class="campaign-content">
                <div class="campaign-text">
                  <p class="campaign-client"><?php the_field('client'); ?></p>
                  <p class="campaign-name"><?php the_title(); ?></p>
                </div>
              </div>
            </div>
          </a>
        </div>

        <?php wp_reset_postdata(); ?>

       <?php if ($i == 1 || $i == 3) echo "</div>"; ?>
      <?php endforeach; ?>


  <?php endif; ?>




<?php get_footer(); ?>
