/*global module:false*/
module.exports = function(grunt) {

  // Load grunt tasks automatically
  require('load-grunt-tasks')(grunt);

  var jsLibs = [
    'node_modules/foundation-sites/dist/js/foundation.js',
    'node_modules/isotope-layout/dist/isotope.pkgd.js',
    'vendors/slick/slick.js',
    'vendors/vimeoapi/jquery.vimeo.api.js',
    'vendors/aos-master/dist/aos.js'
  ];

  var jsApp = [
    'source/js/main.js'
  ];

  var cssLibs = [
    'vendors/slick/slick.css',
    'vendors/slick/slick-theme.css',
    'vendors/aos-master/dist/aos.css'
  ];

  // Project configuration.
  grunt.initConfig({

    pkg: grunt.file.readJSON('package.json'),

    // Task configuration.

    concat: {
      libs: {
        // the files to concatenate
        src: jsLibs,
        // the location of the resulting JS file
        dest: 'build/libs.js'
      },
      app: {
        // the files to concatenate
        src: jsApp,
        // the location of the resulting JS file
        dest: 'build/app.js'
      },
      css: {
        // the files to concatenate
        src: cssLibs,
        // the location of the resulting CSS file
        dest: 'build/libs.css'
      }
    },

    uglify: {
      dist: {
        files: {
          'js/app.min.js': ['build/libs.js', 'build/app.js']
        }
      }
    },

    sass: {
      dev: {
        options: {
          loadPath: ['node_modules/foundation-sites/scss','vendors/font-awesome/scss']
        },
        files: {
          'build/app.css': 'source/scss/main.scss'
        }
      }
    },

    postcss: {
      options: {
        map: true, // inline sourcemaps

        processors: [
          require('autoprefixer')({browsers: 'last 2 versions'}), // add vendor prefixes
        ]
      },
      dist: {
        src: 'build/app.css'
      }
    },

    cssmin: {
        build: {
            files: {
              'css/app.min.css': [ 'build/libs.css', 'build/app.css' ]
            }
        }
    },

    clean: ['build'],

    watch: {
      css: {
        files: 'source/**/*.scss',
        tasks: ['concat:css', 'sass:dev', 'postcss', 'cssmin', 'clean']
      },

      js: {
        files: 'source/**/*.js',
        tasks: ['concat','uglify', 'clean']
      }

    }
  });

  // Default task.
  grunt.registerTask('default', ['concat', 'uglify', 'sass:dev', 'postcss', 'cssmin', 'clean']);

};