<?php get_header(); ?>

<div class="news-slider">
<?php
$args = array(
  'posts_per_page' => '4'
);
$the_query = new WP_Query( $args );

if ( $the_query->have_posts() ) :
    while ( $the_query->have_posts() ) : $the_query->the_post();
      $featureImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>

      <div class="slider-item" style="background-image: url(<?php echo $featureImg[0]; ?>);">
        <div class="row align-middle news-bg-overlay">
          <div class="large-6 columns">
            <div class="news-headline">
              <h1 class="news-title"><?php the_title(); ?></h1>
              <a class="btn hero-btn news-hero-btn" href="<?php echo get_permalink( $post->ID ); ?>">Read More</a>
            </div>
          </div>
        </div>
      </div>

    <?php endwhile;
wp_reset_postdata();
endif; ?>
</div>

<div id="tab-container" class="row filter-tab-container expanded collapse">
  <div class="large-12 columns">

    <div data-sticky-container>
      <div style="width:100%" class="filter-tabs sticky row align-center collapse expanded" data-sticky data-stick-to="top" data-sticky-on="small" data-anchor="tab-container" data-margin-top="<?php echo (is_admin_bar_showing()) ? '6.4' : '4.6';?>">
        <ul class="tabs row expanded align-center" data-tabs id="news-tabs">
          <li class="tabs-title is-active shrink"><a href="#all-news" aria-selected="true">All News</a></li>
          <li class="tabs-title shrink"><a href="#retail-franchisor">Retail / Franchise</a></li>
          <li class="tabs-title shrink"><a href="#destination-travel">Travel / Tourism</a></li>
        </ul>
      </div>
    </div>

    <div class="tabs-content news-tabs" data-tabs-content="news-tabs">

      <div class="tabs-panel is-active" id="all-news">

        <?php echo do_shortcode('[ajax_load_more id="load-more-all" css_classes="load-more-container" post_type="post" scroll="false" posts_per_page="4" button_label="Load More" button_loading_label="Loading news..."]'); ?>

      </div>

      <div class="tabs-panel" id="retail-franchisor">

        <?php echo do_shortcode('[ajax_load_more id="load-more-all" css_classes="load-more-container" post_type="post" taxonomy="industry" taxonomy_terms="retail-franchisor" taxonomy_operator="IN" scroll="false" posts_per_page="4" button_label="Load More" button_loading_label="Loading news..."]'); ?>

      </div>


      <div class="tabs-panel" id="destination-travel">

        <?php echo do_shortcode('[ajax_load_more id="load-more-all" css_classes="load-more-container" post_type="post" taxonomy="industry" taxonomy_terms="destination-travel" taxonomy_operator="IN" scroll="false" posts_per_page="4" button_label="Load More" button_loading_label="Loading news..."]'); ?>

      </div>
    </div>
  </div>
</div>

<?php get_template_part( 'partials/get-in-touch' ); ?>

<?php get_footer(); ?>
