<?php 
/**
 * Template Name: Viewpoint Thank You
 *
 * @package WordPress
*/

@session_start();

$title = "";
$download = "";
$whitepaper = get_query_var("whitepaper");

$args = array(
  'name'        => $whitepaper,
  'post_type'   => 'whitepaper',
  'post_status' => 'publish',
  'numberposts' => 1
);

$lookup = get_posts($args);

if( !empty($lookup) ){
    $lookup = $lookup[0];
    $title = $lookup->post_title;
    $download = get_field("whitepaper_download", $lookup->ID);
}

get_header(); ?>

<?php if( !empty($_SESSION["pardot_validated"]) && !empty($lookup) && !empty($download) ): ?>

<div class="page-hero-block thank-you-hero">
  <div class="row">
    <div class="page-hero-inner">
      <h1 class="page-hero">Thank you!</h1>
      <p class="page-hero-sub"><?php echo $title; ?> should begin to download momentarily.<br>If it doesn’t automatically, please <a class="ty-url" href="<?php echo $download; ?>" target="_blank">click here</a>.</p>
    </div>
  </div>
</div>

<script>
    jQuery(document).ready(function(){
        window.setTimeout(function(){
            window.location = "<?php echo @$download;?>";
        },2500);
    });
</script>

<?php elseif( !empty($_SESSION["pardot_validated"]) && !empty($lookup) && empty($download) ): ?>

<div class="page-hero-block thank-you-hero">
  <div class="row">
    <div class="page-hero-inner">
      <h1 class="page-hero">Sorry</h1>
      <p class="page-hero-sub"><?php echo $title; ?> is currently unavailable, we apologize for the inconvenience and are working on getting this document updated.  Please click <a href="/viewpoint">here</a> to return to Viewpoint.</p>
    </div>
  </div>
</div>

<?php else: ?>

<div class="page-hero-block thank-you-hero">
  <div class="row">
    <div class="page-hero-inner">
      <h1 class="page-hero">Sorry</h1>
      <p class="page-hero-sub">Access to this whitepaper requires registration.<br>Please fill out the form <a class="ty-url" href="/viewpoint/<?php echo $whitepaper; ?>">here</a> to gain instant access.</p>
    </div>
  </div>
</div>

<?php endif; ?>

<div class="row expanded collapse ty-feed">

  <div class="large-12 columns">

    <div class="whitepapers-thank-you-container">
      <p class="text-center ty-heading">More Whitepapers</p>
      <div class="row large-up-3 small-up-1 filter-grid" style="margin:0 auto;">
        <?php
        $args = [
            'post_type' => 'whitepaper',
            'posts_per_page' => 3,
        ];
        $loop = new WP_Query($args);
        while ($loop->have_posts()) {
            $loop->the_post();

            if ( has_post_thumbnail() ) {
                $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large' );
                $whitepaperimage = $large_image_url[0];
           }
            $industry_classes = get_industry_classes($post->ID);
        ?>
          <div class="column column-block filter-item <?php echo $industry_classes; ?>">
            <a class="whitepaper-item-link" href="<?php the_permalink(); ?>">
              <div class="whitepaper-block">
                <div class="whitepaper-thumb" style="background-image:url('<?php echo $whitepaperimage; ?>')"></div>

                <div class="whitepaper-content">
                  <div class="whitepaper-text-section">
                    <p class="whitepaper-title"><?php the_title(); ?></p>
                    <div class="whitepaper-excerpt"><?php the_excerpt(); ?></div>
                  </div>
                </div>
              </div>
            </a>
          </div>

          <?php
          wp_reset_postdata();
        }
        ?>
      </div>

    </div>


      <div class="text-center ty-btns post-padding">
        <a class="btn btn-posts ty-posts" href="/">See All Whitepapers</a>
      </div>

    </div>

  </div>
</div>

<div class="text-cta white-paper-cta">
  <div class="row text-center">
    <div class="small-12 columns">
      We’re <a class="text-cta-url" href="/">H&L Partners</a>, a full-service advertising agency with offices in San Francisco, St. Louis, Boston, Richmond, and Lexington. We develop high-performance advertising, marketing, and promotional programs that help our clients outperform the competition. We'd love to hear from you. Get in touch.
    </div>
  </div>
</div>


<?php get_footer(); ?>