<?php get_header(); ?>

<div class="page-hero-block work-hero">
  <div class="row">
    <div class="page-hero-inner">
      <h1 class="page-hero"><?php the_field('header'); ?></h1>
    </div>
  </div>
</div>

<div id="tab-container" class="row filter-tab-container collapse expanded">
  <div class="small-12 medium-12 large-12 column">

    <div data-sticky-container style="width:100%;">
      <ul style="width:100%" class="filter-tabs sticky row align-center collapse expanded" data-sticky data-anchor="tab-container" data-sticky-on="small" data-margin-top="<?php echo (is_admin_bar_showing()) ? '6.4' : '4.6';?>">
        <li class="tabs-title active"><a href="" data-filter="*">All Work</a></li>
        <li class="tabs-title"><a href="" data-filter=".ind-retail-franchisor">Retail / Franchise</a></li>
        <li class="tabs-title"><a href="" data-filter=".ind-destination-travel">Travel / Tourism</a></li>
      </ul>
    </div>

    <div class="work-container">
      <div class="row medium-up-2 small-up-1 gallery collapse expanded filter-grid">
        <?php
        $args = [
            'post_type' => 'campaign',
            'posts_per_page' => -1,
        ];
        $loop = new WP_Query($args);
        while ($loop->have_posts()) {
            $loop->the_post();

            if ( has_post_thumbnail() ) {
                $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large' );
                $projectimage = $large_image_url[0];

                $industry_classes = get_industry_classes($post->ID);
            }
        ?>
            <div class="column column-block image-block campaign filter-item <?php echo $industry_classes; ?>" style="background-image:url('<?php echo $projectimage; ?>')">
              <a href="<?php the_permalink(); ?>">
                <div class="campaign-inner">
                  <div class="campaign-loader">
          <?php
                    $client_logo = get_field('client_logo');
                    if ( !empty($client_logo) ) {
                      echo "<img class=\"campaign-logo\" src=\"{$client_logo['url']}\">\n";
                    }
          ?>
                  </div>
                  <div class="campaign-content">
                    <div class="campaign-text">
                      <p class="campaign-client"><?php the_field('client'); ?></p>
                      <p class="campaign-name"><?php the_title(); ?></p>
                    </div>
                  </div>
                </div>
              </a>
            </div>

            <?php
            wp_reset_postdata();
        }
        ?>
      </div>
    </div>
  </div>
</div>

<?php get_template_part( 'partials/get-in-touch' ); ?>

<?php get_footer(); ?>