// Background cover for homepage video
var min_w = 300; // minimum video width allowed
var vid_w_orig;  // original video dimensions
var vid_h_orig;
var navHeight = 160;
var shortNavHeight = 83;

jQuery(document).ready(function($) {

  // Initialize Foundation
  $(document).foundation();


  // Mobile Navigation
  $('.mobile-nav-btn').on('click', function (event) {
    $(this).toggleClass('active');

    $('.main-nav').slideToggle(300);
    event.preventDefault();
  });

  /* For scaling navigation */
  if ($('body.home').length > 0) {
    adjustHomeNavOnWidth();
    $(window).scroll(scaleTopNav);
    /* For mobile navigation */
    $(window).resize(adjustHomeNavOnWidth);
  }

  // Background cover for homepage video
  if ($('body.home').length > 0) {
    vid_w_orig = parseInt(jQuery(window).width());
    vid_h_orig = parseInt(jQuery(window).width() * 0.5625);
    jQuery(window).resize(function () { resizeToCover(); });
    jQuery(window).trigger('resize');
  }


  // Initialize Animate on Scroll
  AOS.init({
    once: true,
    disable: 'window.innerWidth < 780'
  });


  // Isotope filtering
  var $grid = $('.filter-grid').isotope({
    itemSelector: '.filter-item',
  });
  $('.filter-tabs').on( 'click', 'a', function(e) {
    e.preventDefault();
    $('.tabs-title').removeClass('active');
    var filterValue = $(this).attr('data-filter');
    $grid.isotope({ filter: filterValue });
  });

  $('.filter-tabs a').on('click',function(){
    // Make all campaigns active/visible
    $( ".campaign" ).each(function( index ) {
      $(this).addClass('active');
    });
  });


  /* For sliders and carousels */
  if ($('.home-slider').length > 0) {
      $(".home-slider").slick({
      dots: true,
      autoplay: true,
      fade: true,
      // speed: 2000,
      // arrows: false,
      // variableWidth: true
    });
  }
  if ($('.about-carousel').length > 0) {
    $(".about-carousel").slick({
      dots: true,
      arrows: true,
      infinite: true,
      slidesToShow: 1,
      slidesToScroll: 1,
      centerMode: true,
      variableWidth: true
    });
  }
  if ($('.news-slider').length > 0) {
      $(".news-slider").slick({
      autoplay: true,
      arrows: false
    });
  }

  /* For campaign rollovers */
  if ($('.campaign').length > 0) {
    activateVisibleCampaigns();
    $(window).scroll(function(){
      activateVisibleCampaigns();
    });
  }

  /* For campaign rollovers */
  if ($('.number-section').length > 0) {
    $(window).scroll(function(){
      activateVisibleNumbers();
    });
  }

  /* For video play button */
  $(".video-icon-wrapper").on('click', function(){
    if ($(this).hasClass('with-modal')){
      return;
    }
    $(this).css('opacity', 0);
    if ($('.home').length > 0 || $('.page-template-template-expertise').length){
      $('.video-player').find('iframe').vimeo("play");
    }
    else{
      var section = $(this).attr('id').split('-').pop(-1);
      $('#campaign-video-container-' + section).find('iframe').vimeo("play");
    }
  });

  /* For Ajax Load More - recalc sticky nav */
  $(window).scroll(function(){
    if ($('.is-at-bottom').length > 0){
      $('.sticky:visible').foundation('_calc', true);
    }
  });

});

function adjustHomeNavOnWidth() {
  var viewportWidth = $(window).width();
  if (viewportWidth >= 780 && $(".top-bar").hasClass("smallnav")) {
    $(".top-bar").removeClass("smallnav");
    $('nav.main-nav').show();
    $('.mobile-nav-btn').removeClass('active');
    scaleTopNav();
  }
  if (viewportWidth < 780 && !$(".top-bar").hasClass("smallnav")){
    $(".top-bar").addClass("smallnav");
    $('nav.main-nav').hide();
    $('.mobile-nav-btn').removeClass('active');
    scaleTopNav();
  }
}

function scaleTopNav(){
  var viewportWidth = $(window).width();
  var screenPosition = $(document).scrollTop();
  if (viewportWidth >= 780) {
    if (screenPosition > 0 && screenPosition < shortNavHeight) {
      // $('.top-bar').removeClass( "smallnav" );
      // $('.top-bar').addClass( "smallnav-mid" );
      $('.top-bar-container').css( "height", (navHeight - screenPosition) + 'px' );
      $('.top-bar').css( "height", (navHeight - screenPosition) + 'px' );
    }
    if (screenPosition > shortNavHeight) {
      $('.top-bar').removeClass( "smallnav-mid" );
      $('.top-bar').addClass( "smallnav" );
      $('.top-bar-container').css( "height", shortNavHeight+'px' );
      $('.top-bar').css( "height", shortNavHeight+'px' );
    }
    if (screenPosition == 0) {
      $('.top-bar').removeClass("smallnav-mid");
      $('.top-bar').removeClass("smallnav");
      $('.top-bar-container').css( "height", navHeight+'px' );
      $('.top-bar').css( "height", navHeight+'px' );
    }
  }
  else{
    $('.top-bar').css( "height", shortNavHeight+'px' );
  }
}

// Background cover for homepage video
function resizeToCover() {
  // set the video viewport to the window size
  jQuery('.home-video-container').width(jQuery(window).width());
  jQuery('.home-video-container').height(jQuery(window).height() - jQuery('.top-bar').height());

  // use largest scale factor of horizontal/vertical
  var scale_h = jQuery(window).width() / vid_w_orig;
  var scale_v = (jQuery(window).height() - jQuery('.top-bar').height()) / vid_h_orig;
  var scale = scale_h > scale_v ? scale_h : scale_v;

  // don't allow scaled width < minimum video width
  if (scale * vid_w_orig < min_w) {scale = min_w / vid_w_orig;};

  // now scale the video
  jQuery('.home-video-iframe').width(scale * vid_w_orig);
  jQuery('.home-video-iframe').height(scale * vid_h_orig);
  // and center it by scrolling the video viewport
  jQuery('.home-video-container').scrollLeft((jQuery('.home-video-iframe').width() - jQuery(window).width()) / 2);
  jQuery('.home-video-container').scrollTop((jQuery('.home-video-iframe').height() - jQuery(window).height()) / 2 - jQuery('.top-bar').height());
};


/* For campaign rollovers */
$.fn.inView = function(){
    //Window Object
    var win = $(window);
    //Object to Check
    obj = $(this);
    //the top Scroll Position in the page
    var scrollPosition = win.scrollTop();
    //the end of the visible area in the page, starting from the scroll position
    var visibleArea = win.scrollTop() + win.height();
    //the end of the object to check
    var objEndPos = (obj.offset().top + obj.outerHeight());
    return(visibleArea >= objEndPos && scrollPosition <= objEndPos ? true : false)
};

function activateVisibleCampaigns(){
    console.log('checking if any campaigns are visible');
    $( ".campaign" ).each(function( index ) {
      if ($(this).inView() && !$(this).hasClass('active')){
        $(this).addClass('active');
        console.log("Activating div number " + index);
      }
    });
}

function activateVisibleNumbers(){
    console.log('checking if any numbers are visible');
    $( ".number-section" ).find('.grid-item').each(function( index ) {
      if ($(this).inView() && $(this).hasClass('hidden')){
        $(this).removeClass('hidden');
        $(this).addClass('fade-in');
        console.log("Activating number " + index);
      }
    });
}

/* For video background */
var timeoutId;
var $videoBgAspect = $(".videobg-aspect");
var $videoBgWidth = $(".videobg-width");
var videoAspect = $videoBgAspect.outerHeight() / $videoBgAspect.outerWidth();

function videobgEnlarge() {
  console.log('resize');
  windowAspect = ($(window).height() / $(window).width());
  if (windowAspect > videoAspect) {
    $videoBgWidth.width((windowAspect / videoAspect) * 100 + '%');
  } else {
    $videoBgWidth.width(100 + "%")
  }
}

$(window).resize(function() {
  clearTimeout(timeoutId);
  timeoutId = setTimeout(videobgEnlarge, 100);
});

$(function() {
  videobgEnlarge();
});

/* END - For video background */

/* For campaign videos */

function loadCampaignVideo(vimeo_id, section){
  $('#campaign-video-thumbs-' + section).find('a').removeClass('active');
  $("#campaign-video-" + vimeo_id + "-" + section).addClass('active');
  $('#campaign-video-container-' + section).find('iframe').attr('src','//player.vimeo.com/video/' + vimeo_id + '?portrait=0&byline=0&title=0&api=1&player_id=' + section);
  $("#video-play-button-" + section).css('opacity', 1);
  return false;
}

/* END - For campaign videos */
