<?php
/**
 * Plugin Name: H&L Greenhorns
 * Description: View and export content submitted from the internship page
 * Version: 1.0.0
 * Author: Matt Johnson
 */

//================================================
// Plugin Menus
//================================================

function greenhorn_menus(){
	add_menu_page('Greenhorns', 'Greenhorns', 'green-foo', 'greenhorn-forms');
	add_submenu_page('greenhorn-forms', 'Registration Form', 'Registration Form', 'manage_options', 'hl-greenhorn-registration', 'hl_greenhorn_registration');
	add_submenu_page(null, 'Greenhorns Download', 'Greenhorns Download', 'manage_options', 'hl-greenhorn-csv', 'hl_greenhorn_csv');
}
add_action('admin_menu','greenhorn_menus');

if($_GET["page"] === "hl-greenhorn-csv"){
	add_action('admin_init', 'hl_greenhorn_csv_generate', 1);
}

//================================================
// Plugin Methods
//================================================

function hl_greenhorn_registration(){
	global $wpdb;

	$total = 0;
	$pages = 1;
	$page = (int) csv_clean_input("p","get",1);
	$next = 1;
	$prev = 1;
	$limit = 10;

	$results = $wpdb->get_results("SELECT * FROM hlp_greenhorns ORDER BY created DESC");

	if(!empty($results)){
		$total = count($results);
		$pages = floor($total / $limit);
		if($pages < 1) $pages = 1;
		if($page > $pages) $page = $pages;

		$next = $page + 1;
		if($next > $pages) $next = $pages;

		$prev = $page - 1;
		if($prev < 1) $prev = 1;

		$offset = ($page - 1) * $limit;
		$results = array_slice($results,$offset,$limit);
	}

	include_once(__DIR__ . "/views/greenhorns.php");
}

//================================================
// Plugin Data Exporter
//================================================

function hl_greenhorn_csv_generate(){
	global $wpdb;
	$results = $wpdb->get_results("SELECT * FROM hlp_greenhorns ORDER BY created DESC");

	if(!empty($results)){

		$filename = "hl-greenhorns." . date("m-d-Y") . ".csv";
		header('Content-Type: text/csv');
		header('Content-Disposition: attachment;filename='.$filename);
		$fp = fopen('php://output','w');

		$fields = "Id,Name,Cover,Resume,Reference,Website,Interest,Office,Describe,Program,Date";

		//Write the header
		$header = array();
		$fields = explode(",",$fields);
		foreach($fields as $field){
			$header[] = ucwords(str_replace("_"," ",$field));
		}
		fputcsv($fp,$header);

		//Write the content
		foreach($results as $row){
			$row = (array) $row;
			foreach($row as $key => $val){
				if($key === "created") $row[$key] = date("m/d/Y h:iA",$val);
				else $row[$key] = csv_export_filter($val);
			}
        	fputcsv($fp,$row);
		}

        fclose($fp);
        die();

	} else {
		echo "<script>window.close();</script>";
	}
}

//================================================
// Plugin Utilities
//================================================

function csv_export_filter($data){
	$data = strip_tags($data);
	$data = str_replace("\r\n","",$data);
	$data = trim($data);
	$pos  = strpos($data,",");
	if($pos !== FALSE) $data = '"'.$data.'"';
	return $data;
}

function csv_clean_input($param="",$method="get",$default=""){
	$value = $default;

	if(strtolower($method) === "get" && isset($_GET[$param])){
		$value = trim(sanitize_text_field($_GET[$param]));
		if(empty($value)) $value = $default;
	}
	else if(strtolower($method) === "post" && isset($_POST[$param])){
		$value = trim(sanitize_text_field($_POST[$param]));
		if(empty($value)) $value = $default;
	}

	return $value;
}
