<?php
/**
 * H&L Partners helper functions
 *
 * @package WordPress
 * @subpackage H&L Partners
 * @since Version 1.0
 */

//============================================================
// Helper Methods
//============================================================

function get_session_var($key="",$default=""){
	if( isset($_SESSION[$key]) ) return $_SESSION[$key];
	else return $default;
}

function hlp_get_post_id($slug=""){
	$id = "";
	if(!empty($slug)){
		global $wpdb;
		$temp = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '$slug'");
		if(!empty($temp)) $id = (int) $temp;
	}
	return $id;
}

function hlp_get_client_id($slug=""){
	$id = "";
	if(!empty($slug)){
		global $wpdb;
		$temp = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '$slug' AND post_type = 'hlp-clients'");
		if(!empty($temp)) $id = (int) $temp;
	}
	return $id;
}

function hlp_get_client_slug($id=""){
	$slug = "";
	if(!empty($id)){
		global $wpdb;
		$temp = $wpdb->get_var("SELECT post_name FROM $wpdb->posts WHERE ID = '$id' AND post_type = 'hlp-clients'");
		if(!empty($temp)) $slug = $temp;
	}
	return $slug;
}

function hlp_get_client_list(){
	$clients = array();

	global $wpdb;
	$temp = $wpdb->get_results("SELECT post_name FROM $wpdb->posts WHERE post_type = 'hlp-clients'",ARRAY_N);
   if(!empty($temp)){
	   foreach($temp as $slug){
		   $clients[] = $slug[0];
	   }
   }

	return $clients;
}

function hlp_get_campaign_id($slug=""){
	$id = "";
	if(!empty($slug)){
		global $wpdb;
		$temp = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '$slug' AND post_type = 'hlp-campaigns'");
		if(!empty($temp)) $id = (int) $temp;
	}
	return $id;
}

function hlp_get_campaign_slug($id=""){
	$slug = "";
	if(!empty($id)){
		global $wpdb;
		$temp = $wpdb->get_var("SELECT post_name FROM $wpdb->posts WHERE ID = '$id' AND post_type = 'hlp-campaigns'");
		if(!empty($temp)) $slug = $temp;
	}
	return $slug;
}

function hlp_get_campaigns_list(){
	$campaigns = array();

	global $wpdb;
	$temp = $wpdb->get_results("SELECT post_name FROM $wpdb->posts WHERE post_type = 'hlp-campaigns'",ARRAY_N);
	if(!empty($temp)){
	   foreach($temp as $slug){
		   $campaigns[] = $slug[0];
	   }
   }

	return $campaigns;
}

function hlp_get_project_id($slug=""){
	$id = "";
	if(!empty($slug)){
		global $wpdb;
		$temp = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '$slug' AND post_type = 'hlp-projects'");
		if(!empty($temp)) $id = (int) $temp;
	}
	return $id;
}

function hlp_get_location_id($slug=""){
	$id = "";
	if(!empty($slug)){
		global $wpdb;
		$temp = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '$slug' AND post_type = 'hlp-locations'");
		if(!empty($temp)) $id = (int) $temp;
	}
	return $id;
}

function curl_fetch_data($url){
   $ch = curl_init();
   curl_setopt($ch, CURLOPT_URL, $url);
   curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
   $data = curl_exec($ch);
   curl_close($ch);
   return $data;
}

//============================================================
// Debug Methods
//============================================================

function wp_vardump($data){
	echo "<pre>";
	var_dump($data);
	echo "</pre>";
}

function wp_dumpdie($data){
	wp_vardump($data);
	die();
}

//============================================================
// Redirect Methods
//============================================================

function hlp_redirect_to($path="/"){
	header("location:$path");
	die();
}

function hlp_redirect_404(){
	hlp_redirect_to("/page-not-found");
}

//============================================================
// Clean Input Get/Post
//============================================================

function hlp_get_input($field='',$mode='post',$default=''){
	$var = $default;
	if($mode === 'post'){
		if( isset($_POST[$field]) ){
			$var = $_POST[$field];
			if(is_string($var) && !is_array($var)){
				$var = trim($var);
				$var = hlp_filter_xss($var);
			}
		}
	} else {
		if( isset($_GET[$field]) ){
			$var = $_GET[$field];
			if(is_string($var) && !is_array($var)){
				$var = trim($var);
				$var = hlp_filter_xss($var);
			}
		}
	}
	return stripslashes_deep($var);
}

function hlp_filter_xss($input=''){
	$filtered = "";
	if(is_string($input) && !is_array($input)){
		$allowed_html = array(
			"a" 		=> array("href" => array(),"title" => array(), "target" => array()),
			"b" 		=> array(),
			"strong" 	=> array(),
			"em" 		=> array(),
			"i" 		=> array(),
			"strike" 	=> array(),
			"ol" 		=> array(),
			"ul" 		=> array(),
			"li" 		=> array(),
			"p" 		=> array(),
			"br" 		=> array()
		);
		$filtered = wp_kses($input,$allowed_html);
	}
	return $filtered;
}

//============================================================
// Render Views to String
//============================================================

function hlp_render_view($view=NULL,$data=NULL){
	$output = "";
	if( !empty($data) ){
		ob_start();
		if( file_exists(TEMPLATEPATH . "/includes/" . $view . ".php") ){
			if(is_array($data)) extract($data);
			include(TEMPLATEPATH . "/includes/" . $view . ".php");
		}
		$output = ob_get_clean();
	}
	return $output;
}

//============================================================
// HTML Email Sender
//============================================================

function hlp_send_html_email($to="",$sub="",$msg=""){
	$headers = array();
	$headers[] = "Content-Type: text/html; charset=UTF-8";
	$headers[] = 'From: H&L Website <postmaster@handlpartners.com>';
	wp_mail($to,$sub,$msg,$headers);
}

//============================================================
// Build Desktop Navigation
//============================================================

function build_desktop_navigation($mode='top'){
	global $post;
	$current_page = @$post->ID;
	$current_main = null;
	$current_sub = null;

	$args = array(
    'order'                  => 'ASC',
    'orderby'                => 'menu_order',
    'post_type'              => 'nav_menu_item',
    'post_status'            => 'publish',
    'output'                 => ARRAY_A,
    'output_key'             => 'menu_order',
    'nopaging'               => true,
    'update_post_term_cache' => false);

	$items = wp_get_nav_menu_items("desktop",$args);
	$parents = array();
	$children = array();

	$get_foundation_subs = function($id,$children){
		array_key_exists($id,$children) ? $subs = $children[$id] : $subs = array();
		return $subs;
	};

	//Find all children and save ids
	foreach($items as $nav){
		//Create the array if needed
		if( !empty($nav->menu_item_parent) && !array_key_exists($nav->menu_item_parent,$children) ){
			$children[$nav->menu_item_parent] = array();
		}

		if( !empty($nav->menu_item_parent) ){
			//This is a child item
			array_push($children[$nav->menu_item_parent],(object) array("oid"=>$nav->object_id,"id"=>$nav->ID,"pid"=>$nav->menu_item_parent,"title"=>$nav->title,"url"=>$nav->url));
			if($nav->object_id == $current_page){
				$current_main = $nav->menu_item_parent;
				$current_sub = $nav->ID;
			}
		} else {
			//This is a parent item
			array_push($parents,(object) array("oid"=>$nav->object_id,"id"=>$nav->ID,"pid"=>0,"title"=>$nav->title,"url"=>$nav->url));
			if($nav->object_id == $current_page){
				$current_main = $nav->ID;
				$current_sub = null;
			}
		}
	}

	if( empty($current_main) ){
		$segments = explode("/",strtok($_SERVER["REQUEST_URI"],'?'));
		$paths = array();
		$hidden = array("white-papers","viewpoint-thank-you");

		foreach($segments as $seg){
			if( !empty($seg) ) $paths[] = $seg;
		}

		if(count($paths) > 2 && !in_array($paths[1],$hidden)){
			$current_page = hlp_get_post_id($paths[1]);
		} else {
			$current_page = hlp_get_post_id($paths[0]);
		}

		foreach($parents as $nav){
			if($nav->oid == $current_page){
				$current_main = $nav->id;
				$current_sub = null;
				break;
			} else {
				$subs = $get_foundation_subs($nav->id,$children);
				foreach($subs as $sub){
					if($sub->oid == $current_page){
						$current_main = $sub->pid;
						$current_sub = $sub->id;
						break;
					}
				}
			}
		}
	}

	if($mode === 'top') include_once(TEMPLATEPATH . "/includes/navigation/navigation-top.php");
	else include_once(TEMPLATEPATH . "/includes/navigation/navigation-side.php");
}

//============================================================
// Build Mobile Navigation
//============================================================

function build_mobile_navigation(){
	global $post;
	$current_page = @$post->ID;
	$current_main = null;
	$current_sub = null;

	$args = array(
    'order'                  => 'ASC',
    'orderby'                => 'menu_order',
    'post_type'              => 'nav_menu_item',
    'post_status'            => 'publish',
    'output'                 => ARRAY_A,
    'output_key'             => 'menu_order',
    'nopaging'               => true,
    'update_post_term_cache' => false );

	$items = wp_get_nav_menu_items("mobile", $args);
	$parents = array();
	$children = array();

	$get_foundation_subs = function($id,$children){
		array_key_exists($id,$children) ? $subs = $children[$id] : $subs = array();
		return $subs;
	};

	//Find all children and save ids
	foreach($items as $nav){
		//Create the array if needed
		if( !empty($nav->menu_item_parent) && !array_key_exists($nav->menu_item_parent,$children) ){
			$children[$nav->menu_item_parent] = array();
		}

		//Store all required info
		if( !empty($nav->menu_item_parent) ){
			array_push($children[$nav->menu_item_parent],array("oid"=>$nav->object_id,"id"=>$nav->ID,"pid"=>$nav->menu_item_parent,"title"=>$nav->title,"url"=>$nav->url));
			if($nav->object_id == $current_page){
				$current_main = $nav->menu_item_parent;
				$current_sub = $nav->ID;
			}
		} else {
			array_push($parents,array("oid"=>$nav->object_id,"id"=>$nav->ID,"pid"=>0,"title"=>$nav->title,"url"=>$nav->url));
			if($nav->object_id == $current_page){
				$current_main = $nav->ID;
				$current_sub = null;
			}
		}
	}

	if( empty($current_main) ){
		$segments = explode("/",strtok($_SERVER["REQUEST_URI"],'?'));
		$paths = array();
		$hidden = array("white-papers","viewpoint-thank-you");

		foreach($segments as $seg){
			if( !empty($seg) ) $paths[] = $seg;
		}

		if(count($paths) > 2 && !in_array($paths[1],$hidden)){
			$current_page = hlp_get_post_id($paths[1]);
		} else {
			$current_page = hlp_get_post_id($paths[0]);
		}

		foreach($parents as $nav){
			if($nav->oid == $current_page){
				$current_main = $nav->id;
				$current_sub = null;
				break;
			} else {
				$subs = $get_foundation_subs($nav->id,$children);
				foreach($subs as $sub){
					if($sub->oid == $current_page){
						$current_main = $sub->pid;
						$current_sub = $sub->id;
						break;
					}
				}
			}
		}
	}

	include_once(TEMPLATEPATH . "/includes/navigation/navigation-mobile.php");
}

//============================================================
// EOF
//============================================================
