<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php wp_title(''); ?></title>
<?php wp_head();?>
</head>
<body>

<?php //include_once(TEMPLATEPATH . "/includes/google/analytics.php"); ?>

<div class="off-canvas-wrapper">
<div class="off-canvas-wrapper-inner" data-off-canvas-wrapper>
<div class="off-canvas position-left" id="off-canvas-leftmenu" data-off-canvas data-position="left">
    <?php build_mobile_navigation(); ?>
</div>

<div class="off-canvas-content" data-off-canvas-content>

<div id="menu-toggle" class="hide-for-large">
    <div class="menu-icon" type="button" data-toggle="off-canvas-leftmenu" aria-expanded="false" aria-controls="offCanvasLeft"></div>
</div>

<div id="menu-logo" class="hide-for-large">
    <a href="/"><img src="<?php echo get_template_directory_uri(); ?>/assets/img/logo.png" /></a>
</div>

<nav id="page-nav" class="show-for-large">
    <div id="page-nav-wrap">
        <div class="row">
            <div class="small-12 columns">
                <div id="page-menu">
                    <?php build_desktop_navigation('top'); ?>
                </div>
            </div>
        </div>
    </div>
</nav>

<section id="page" class="clearfix">
<div id="page-wrap" class="clearfix">

<div id="page-left">
    <a id="page-logo" href="/"><img src="<?php echo get_template_directory_uri(); ?>/assets/img/logo.png" /></a>
    <div id="page-submenu">
        <div id="news-menus">
            <select onchange="window.location.href = this.value;">
                <?php
                    $cats = array(
                        "/news" => "All Articles",
                        "/news/category/retail" => "Retail/Franchise",
                        "/news/category/travel" => "Destination Travel",
                        "/news/category/san-francisco" => "San Francisco",
                        "/news/category/saint-louis" => "Saint Louis",
                        "/news/category/boston" => "Boston",
                        "/news/category/richmond" => "Richmond"
                    );

                    $request = trim($_SERVER['REQUEST_URI'],"/");
                    $segs = explode("/",$request);
                    if( count($segs) < 3 ) $active = "/news";
                    else $active = "/" . implode("/",$segs);

                    foreach($cats as $link => $label):
                ?>

                <option <?php if($link === $active) echo 'selected=\'selected\''; ?> value="<?php echo $link;?>">
                    <?php echo $label;?>
                </option>

                <?php endforeach; ?>
            </select>
        </div>
    </div>
</div>
<div id="page-right">
