
<?php
    $attachment = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
    $image = @$attachment[0];
    if(empty($image)) $image = "/wp-content/uploads/2016/02/header3.jpg";

    $terms = get_the_category($post->ID);
    $cats = array();

    foreach($terms as $c){
        $cat = get_category($c);
        $cats[] = array('name' => $cat->name,'slug' => $cat->slug);
    }

    if( empty($cats) || $cats[0]['slug'] === "uncategorized" ) $maincat = "news";
    else $maincat = $cats[0]['name'];
?>

<div class="news-item row">
    <div class="small-4 medium-4 large-7 columns news-left">
        <div class="news-image" style="background-image:url(<?php echo $image;?>);"></div>
    </div>
    <div class="small-8 medium-8 large-5 columns news-right">
        <div class="news-block">
            <div class="news-info clearfix">
                <span class="news-date left"><?php echo get_the_date("m/d/Y"); ?></span>
                <span class="news-type right"><?php echo $maincat;?></span>
            </div>
            <h1><?php the_title(); ?></h1>
            <div class="news-copy"><?php the_excerpt(); ?></div>
            <a class="hlbtn" href="<?php the_permalink();?>">Read More</a>
        </div>
    </div>
</div>
