
<?php get_header("news"); ?>

<div id="news-nav" class="clearfix">
    <span class="left"><?php previous_posts_link('<i class="fa fa-arrow-circle-left"></i> Previous Page'); ?></span>
    <span class="right"><?php next_posts_link('Next Page <i class="fa fa-arrow-circle-right"></i>'); ?></span>
</div>

<div id="news-excerpts">
    <?php
    	if( have_posts() ): while( have_posts() ): the_post();
    	$attachment = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
    	$image = @$attachment[0];
    	if(empty($image)) $image = "/wp-content/uploads/2016/02/header3.jpg";

        $terms = get_the_category($post->ID);
        $cats = array();

        foreach($terms as $c){
            $cat = get_category($c);
            $cats[] = array('name' => $cat->name,'slug' => $cat->slug);
        }

        if( empty($cats) || $cats[0]['slug'] === "uncategorized" ) $maincat = "news";
        else $maincat = $cats[0]['name'];
    ?>

        <div class="news-item row">
            <div class="small-4 medium-7 large-7 columns news-left">
                <div class="news-image" style="background-image:url(<?php echo $image;?>);"></div>
            </div>
            <div class="small-8 medium-5 large-5 columns news-right">
                <div class="news-block">
                    <div class="news-info clearfix">
                        <span class="news-date left"><?php echo get_the_date("m/d/Y"); ?></span>
                        <span class="news-type right"><?php echo $maincat;?></span>
                    </div>
                    <h1><?php the_title(); ?></h1>
                    <div class="news-copy"><?php the_excerpt(); ?></div>
                    <a class="hlbtn" href="<?php the_permalink();?>">Read More</a>
                </div>
            </div>
        </div>

    <?php endwhile; endif; ?>
</div>

<div id="news-nav-btm" class="clearfix">
    <span class="left"><?php previous_posts_link('<i class="fa fa-arrow-circle-left"></i> Previous Page'); ?></span>
    <span class="right"><?php next_posts_link('Next Page <i class="fa fa-arrow-circle-right"></i>'); ?></span>
</div>

<?php if( !have_posts() ): ?>

    <div id="news-nav" class="clearfix"></div>
    <div id="page-banner" style="background-image:url(/wp-content/uploads/2016/02/header3.jpg);"></div>

    <div id="news-single">
        <h1>Sorry</h1>
        <br/>
        <p>There are currently no articles in this category.  Please use the button below to return to the main news section.</p>
    </div>

    <div id="news-footer" class="clearfix">
        <a href="/news" class="hlbtn back right">Back To News</a>
    </div>

<?php
endif;
get_footer();
